<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Am\Entities\PurchaceRequest;
use Modules\Sc\Entities\DocumentNumber;
use Modules\Sc\Entities\GoodsReceivedMr;
use Modules\Sc\Entities\GoodsTransferHeader;
use Modules\Sc\Entities\GrnHeader;
use Modules\Sc\Entities\MaterialRequisitionHeader;
use Modules\Sc\Entities\MiHeader;
use Modules\Sc\Entities\PurchaseOrderHeader;
use Modules\Sc\Entities\PurchaseRequestHeader;
use Modules\Sc\Entities\StoreLocation;

class ReferenceIDController extends Controller
{
    public function grnHeaderMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix =  $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_grn_headers WHERE document_no = "100" AND external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "grnHeaderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function grnReturnMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_grn_headers WHERE document_no = "110" AND external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "grnReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function miHeaderMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_mi_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "miHeaderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function purchaseRequestMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_purchase_request_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "purchaseRequestMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function purchaseOrderMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_purchase_order_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "purchaseOrderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function materialRequisitionMaxIDMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                // $result = DB::select('SELECT MAX(external_id) AS id 
                //     FROM sc_material_requisition_headers 
                //     WHERE external_id LIKE "%' . $prefix . '%"');

               $result = DB::select('SELECT
                MAX(CAST(RIGHT(external_id, 5) AS UNSIGNED)) AS id 
                    FROM sc_material_requisition_headers 
                    WHERE external_id LIKE "%' . $prefix . '%"');

                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                       
                        $id = preg_replace('/\D/', '', $id);
                    }
                }

                $id += 1;
                
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialRequisitionMaxIDMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $result);
        }
        return response()->json(["data" => $responseBody]);
    }
   

    
    // public function materialRequisitionMaxIDMaxID($store_id)
    // {
    //     try {
    //         $store = StoreLocation::find($store_id);
    //         $id = 0;
    //         $prefix = "";
    //         if ($store) {
    //             $prefix = $store->prefix;
                
    //             // Get all external_ids that match the prefix
    //             $result = DB::select('SELECT external_id 
    //                 FROM sc_material_requisition_headers 
    //                 WHERE external_id LIKE ?', 
    //                 ['%' . $prefix . '%']
    //             );

    //             $maxNumeric = 0;
                
    //             foreach ($result as $res) {
    //                 if ($res->external_id) {
    //                     // Extract last 5 characters
    //                     $lastFiveChars = substr($res->external_id, -5);
                        
    //                     // Convert to integer (removes leading zeros automatically)
    //                     $numericValue = (int)$lastFiveChars;
                        
    //                     // Check if it's greater than current max
    //                     if ($numericValue > $maxNumeric) {
    //                         $maxNumeric = $numericValue;
    //                     }
    //                 }
    //             }
                
    //             $id = $maxNumeric + 1;
    //         }
            
    //         $responseBody = $this->responseBody(true, "ReferenceIDController", "materialRequisitionMaxIDMaxID", ['id' => $id, 'prefix' => $prefix]);
    //     } catch (Exception $exception) {
    //         $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception->getMessage());
    //     }
    //     return response()->json(["data" => $responseBody]);
    // }







    public function goodsTransferMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_goods_transfer_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsTransferMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function goodsTransferMRMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_goods_transfer_header_m_rs WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsTransferMRMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function materialIssueMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_mi_headers WHERE external_id LIKE "%' .$prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialIssueMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "materialIssueMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }





    public function goodsReceivedMrMaxID($store_id)
    {
        try {

            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
    
                // Search for reference numbers starting with GR- + prefix
                $result = DB::select('SELECT refferance_no FROM sc_goods_received_mrs WHERE refferance_no LIKE ?', ["%GR-{$prefix}%"]);
    
                $maxNumeric = 0;
    
                foreach ($result as $res) {
                    if ($res->refferance_no) {
                        // Match pattern like: GR-BL700001
                        if (preg_match('/GR-' . preg_quote($prefix, '/') . '(\d+)/', $res->refferance_no, $matches)) {
                            $num = (int)$matches[1];
                            if ($num > $maxNumeric) {
                                $maxNumeric = $num;
                            }
                        }
                    }
                }
    
                $id = $maxNumeric + 1;
            }
            // if ($store) {
            //     $prefix = $store->prefix;
            //     $result = DB::select('SELECT MAX(refferance_no) AS id FROM sc_goods_received_mrs WHERE refferance_no LIKE "%' . $prefix . '%"');
            //     foreach ($result as $res) {
            //         if ($res->id) {
            //             $id = $res->id;
            //             $id = preg_replace('/\D/', '', $id);
            //         }
            //     }
            //     $id += 1;
            // }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsReceivedMrMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function rawMaterialRequisitionMaxIDMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_raw_material_requisition_headers 
                                        WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }

            $responseBody = $this->responseBody(true, "ReferenceIDController", "rawMaterialRequisitionMaxIDMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $result);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function rawMaterialIssueMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_raw_mi_headers WHERE external_id LIKE "%' .$prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "rawMaterialIssueMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "rawMaterialIssueMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function weighBillMaxID()
    {
        try {
            //$store = StoreLocation::find($store_id);
            $id = 0;
            $result = DB::select('SELECT MAX(ticket_no) AS id FROM sc_weigh_bill_header');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
            $id += 1;
            //$prefix = "";
            // if ($store) {
            //     $prefix = $store->prefix;
            //     $result = DB::select('SELECT MAX(external_id) AS id FROM sc_raw_mi_headers WHERE external_id LIKE "%' .$prefix . '%"');
            //     foreach ($result as $res) {
            //         if ($res->id) {
            //             $id = $res->id;
            //             $id = preg_replace('/\D/', '', $id);
            //         }
            //     }
            //     $id += 1;
            // }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "weighBillMaxID", ['id' => $id]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "weighBillMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function goodsReceivedBagsMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix =  $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id 
                                    FROM sc_bags_grn_headers 
                                    WHERE document_no = "100" AND external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsReceivedBagsMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function materialRequisitionBagsMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_bags_material_requisition_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialRequisitionBagsMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $result);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function materialIssueBagsMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id 
                        FROM sc_bags_mi_headers 
                        WHERE external_id 
                        LIKE "%' .$prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialIssueBagsMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "materialIssueBagsMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function materialReturnBagsHeaderMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_bags_material_return_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialReturnBagsHeaderMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function goodsTransferBagsMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id FROM sc_bags_goods_transfer_headers WHERE external_id LIKE "%' . $prefix . '%"');
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "goodsTransferBagsMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function grnReturnBagsMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select('SELECT MAX(external_id) AS id 
                                        FROM sc_bags_grn_headers 
                                        WHERE document_no = "110" 
                                        AND external_id 
                                        LIKE "%' . $prefix . '%"');

                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                    }
                }
                $id += 1;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "grnReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    public function bagsCuttingDispatchMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select(
                    'SELECT MAX(external_id) AS id 
                     FROM sc_bags_cutting_dispatch_headers 
                     WHERE external_id LIKE ?', 
                    ['%' . $prefix . '%']
                );
               
                // $result = DB::select('SELECT MAX(external_id) AS id 
                //                         FROM sc_bags_cutting_dispatch_headers 
                //                         AND external_id 
                //                         LIKE "%' . $prefix . '%"');
                //                         dd($result);
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                        
                    }
                }
                $id += 1;
            }
            
            $responseBody = $this->responseBody(true, "ReferenceIDController", "bagsCuttingDispatchMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    public function bagsCuttingReturnMaxID($store_id)
    {
        try {
            $store = StoreLocation::find($store_id);
            $id = 0;
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
                $result = DB::select(
                    'SELECT MAX(external_id) AS id 
                     FROM sc_bags_cutting_return_headers 
                     WHERE external_id LIKE ?', 
                    ['%' . $prefix . '%']
                );
               
                // $result = DB::select('SELECT MAX(external_id) AS id 
                //                         FROM sc_bags_cutting_dispatch_headers 
                //                         AND external_id 
                //                         LIKE "%' . $prefix . '%"');
                //                         dd($result);
                foreach ($result as $res) {
                    if ($res->id) {
                        $id = $res->id;
                        $id = preg_replace('/\D/', '', $id);
                        
                    }
                }
                $id += 1;
            }
            
            $responseBody = $this->responseBody(true, "ReferenceIDController", "bagsCuttingReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }

    /*public function materialReturnMaxID($store_id)
    {
        try {
            $tbl = MiHeader::all();
            $id = 1;
            if (count($tbl) > 0) {
                $id = $tbl[count($tbl) - 1]['internal_id'] + 1;
            }
            $store = StoreLocation::find($store_id);
            $prefix = "";
            if ($store) {
                $prefix = $store->prefix;
            }
            $responseBody = $this->responseBody(true, "ReferenceIDController", "materialReturnMaxID", ['id' => $id, 'prefix' => $prefix]);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "ReferenceIDController", "materialReturnMaxID", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }*/


    private function getDocumentPrefix($document_no)
    {
        $document_no = DocumentNumber::where('document_number', '=', $document_no)->first();
        $prefix = "";
        if ($document_no) {
            $prefix = $document_no->prefix;
        }

        return $prefix;
    }



    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
