<?php

namespace Modules\Sc\Http\Controllers;

use Exception;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Hr\Entities\Employee;
use Modules\Sc\Entities\BagMaterialRequisitionData;
use Modules\Sc\Entities\BagMaterialRequisitionHeader;
use Modules\St\Entities\Product;
use Modules\St\Entities\ProductUnit;

class RetrieveMRBagsController extends Controller
{
    public function allMaterialRequisition()
    {
        try {

            $query = 'SELECT sc_bags_material_requisition_headers.trans_date,
            sc_bags_material_requisition_headers.external_id,
            sc_bags_material_requisition_headers.internal_id,
            sc_store_locations.`name` AS store,
            hr_employee_departments.department
            FROM sc_bags_material_requisition_headers
            INNER JOIN sc_store_locations ON sc_bags_material_requisition_headers.store_id = sc_store_locations.id
            INNER JOIN hr_employee_departments ON sc_bags_material_requisition_headers.dept_id = hr_employee_departments.department_id
		    INNER JOIN sc_bags_material_requisition_data ON sc_bags_material_requisition_headers.internal_id = sc_bags_material_requisition_data.internal_id 
            WHERE (sc_bags_material_requisition_data.quantity) - (sc_bags_material_requisition_data.transfer_quantity+sc_bags_material_requisition_data.issues_quantity) > 0 
            AND sc_bags_material_requisition_data.`status` !=2   
            GROUP BY sc_bags_material_requisition_data.internal_id 
            ORDER BY sc_bags_material_requisition_headers.trans_date ASC';

            $mrHeaders = DB::select($query);

            $responseBody = $this->responseBody(true, "RetrieveMRBagsController", "allMaterialRequisition", $mrHeaders);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "RetrieveMRBagsController", "error", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }


    private function checkInValiedRetriveHeader($id)
    {

        $result = DB::select('SELECT SUM(quantity) - SUM(transfer_quantity+issues_quantity) AS quantity FROM sc_bags_material_requisition_data WHERE internal_id = "' . $id . '" GROUP BY internal_id');
        if ($result) {
            $quantity = $result[0]->quantity;
            if ($quantity > 0) {
                return true;
            }
        }
        return false;
    }


    public function allMaterialRequisitionData($id)
    {
        try {
            $query = 'SELECT sc_bags_material_requisition_data.mr_data_id,st_products.product_id,
            st_products.product_name,
            (sc_bags_material_requisition_data.quantity-(sc_bags_material_requisition_data.transfer_quantity+sc_bags_material_requisition_data.issues_quantity)) AS quantity,
            st_product_units.`name` AS unit
            FROM sc_bags_material_requisition_data 
            INNER JOIN st_products ON sc_bags_material_requisition_data.product_id = st_products.product_primary_id
            INNER JOIN st_product_units ON sc_bags_material_requisition_data.unit_id = st_product_units.id
            WHERE sc_bags_material_requisition_data.internal_id = "' . $id . '"  AND (sc_bags_material_requisition_data.quantity- (sc_bags_material_requisition_data.issues_quantity+sc_bags_material_requisition_data.transfer_quantity)) != 0 AND (sc_bags_material_requisition_data.status < 2)';
            $data = DB::select($query);
            $responseBody = $this->responseBody(true, "RetrieveMRBagsController", "allMaterialRequisitionData", $data);
        } catch (\Exception $exception) {
            $responseBody = $this->responseBody(false, "RetrieveMRBagsController", "allMaterialRequisitionData", $exception);
        }

        return response()->json(["data" => $responseBody]);
    }




    public function getSelectedMR($id)
    {
        try {
            $grn = BagMaterialRequisitionHeader::find($id);
            //$grn_data = MaterialRequisitionData::where('internal_id', '=', $id)->get();
            $query = 'SELECT *FROM sc_bags_material_requisition_data 
            WHERE sc_bags_material_requisition_data.internal_id = "' . $id . '" 
            AND (sc_bags_material_requisition_data.quantity- (sc_bags_material_requisition_data.issues_quantity+sc_bags_material_requisition_data.transfer_quantity)) != 0 AND (sc_bags_material_requisition_data.status < 2)';
            $grn_data = DB::select($query);
            foreach ($grn_data as $data) {
                $product = Product::find($data->product_id);
                $data->product = $product->product_name;
                $uom = ProductUnit::find($data->unit_id);
                $uom_arr = [];
                if ($uom) {
                    array_push($uom_arr, ["value" => $uom->id, "text" => $uom->name]);
                }
                $data->quantity = ($data->quantity - ($data->transfer_quantity + $data->issues_quantity));
                $data->uom = $uom_arr;
                $data->product_primary_id = $product->product_primary_id;
                $data->product_id = $product->product_id;
            }
            $grn->data = $grn_data;
            $responseBody = $this->responseBody(true, "RetrieveMRBagsController", "getGrn", $grn);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "RetrieveMRBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }




    public function getSelectedMRHeader($id)
    {
        try {
            $mr_header = BagMaterialRequisitionHeader::find($id);
            $responseBody = $this->responseBody(true, "RetrieveMRBagsController", "getGrn", $mr_header);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "RetrieveMRBagsController", "error", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }



    public function change_status($id)
    {
        try {
            $mr_data = BagMaterialRequisitionData::find($id);
            $mr_data->status = 2;
            $mr_data->update();
            $responseBody = $this->responseBody(true, "RetrieveMRBagsController", "change_status", true);
        } catch (Exception $exception) {
            $responseBody = $this->responseBody(false, "RetrieveMRBagsController", "change_status", $exception);
        }
        return response()->json(["data" => $responseBody]);
    }


    /**
     * responseBody
     * This is used to create response.
     * @param success This is the paramter require boolean
     * @param name This is the paramter require ui table name
     * @param message This is the paramter require message content
     * @param result This is the paramter require result as some of data to return client
     * @return Json This returns as response.
     */
    private function responseBody($success, $name, $message, $result)
    {
        $body = [
            "success" => $success,
            "message" => $message,
            "name" => $name,
            "result" => $result
        ];
        return $body;
    }
}
