
var action = "save";
var tableData = undefined;
var GRN_ID = undefined;
var REFFERANCE_ID = undefined;
var EXTERNAL_ID = undefined;
$(document).ready(function () {
    $('#cmbManufacturingOrder').select2();
    $('#cmbPoNo').select2();
    $('.status_btn').hide();
    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);

    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Available Qty', 'Qty', 'Comment', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'string', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });

    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        cells[4].childNodes[0].value = getAvailableQty(data[0], $('#cmbStores').val());
        var input = productChooser.getInput();
        input.focus();


        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });

    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }
    });

    //allEmployees();
    allStores();
    allCuttingCenters();
    allPurchaseOrder();
    // allManufacturingOrder();
    newReferanceID($('#cmbStores').val());



    $('#btnSave').on('click', function () {

        if ($(this).text() == 'Save') {
            disableSaveButton();
            saveBagsCuttingReturn();
        } else {
            updateBagsCuttingReturn();
        }
    });




    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        GRN_ID = id;
        getBagsCuttingReturn(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('#btnRetrieveDispatch').hide();
            $('.status_btn').hide();
        }

    } else {
        tableData.add_empty_row();
    }



    // $('#txtgrn_id').on('input', function () {
    //     grnChooser.showChooser($(this));
    // });


    // $('#txtSupplier').on('input', function () {
    //     supplierChooser.showChooser($(this));
    // });


    // supplierChooser.on('select', function (event, data) {
    //     $('#txtSupplier').val(data[1]);
    //     $('#txtSupplier').attr("data-id", data[0]);
    //     var input = supplierChooser.getInput();
    //     input.focus();
    // });


    // grnChooser.on('select', function (event, data) {
    //     getGrn(data[0]);
    //     $('#txtgrn_id').val(data[0]);
    //     $('#txtgrn_id').attr("data-id", data[0]);
    //     var input = grnChooser.getInput();
    //     input.focus();
    // });


    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    // $('#txtPrintingDamage').on('change', function () {
    //     calculateTotalDamage();
    // });

    // $('#txtSealDamage').on('change', function () {
    //     calculateTotalDamage();
    // });
    // $('#txtGazzetIssues').on('change', function () {
    //     calculateTotalDamage();
    // });

    // $('#txtOtherDamage').on('change', function () {
    //     calculateTotalDamage();
    // });

    // $('#txtCuttingDamage').on('change', function () {
    //     calculateTotalDamage();
    // });
    
    $('#txtPrintingDamage, #txtSealDamage, #txtGazzetIsses, #txtOtherDamage, #txtCuttingDamage').on('change', function () {
        calculateTotalDamage();
    });

    $('#btnApprove').on('click', function () {
        change_status_confirmation(GRN_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(GRN_ID, 2, "Are you sure want to reject?");
    });


});

function calculateTotalDamage() { 
    var printingDamage = parseFloat($('#txtPrintingDamage').val()) || 0;
    var sealDamage = parseFloat($('#txtSealDamage').val()) || 0;
    var gazzetIsses = parseFloat($('#txtGazzetIsses').val()) || 0;
    var otherIssues = parseFloat($('#txtOtherDamage').val()) || 0;
    var companyDamage = printingDamage + sealDamage + gazzetIsses + otherIssues;
    $('#txtCompanyDamage').val(companyDamage.toFixed(2));
    var cutting_damage = parseFloat($('#txtCuttingDamage').val()) || 0;
    var totalDamage = companyDamage + cutting_damage;
    $('#txtTotalDamage').val(totalDamage.toFixed(2));
}



function allCuttingCenters() {
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allCuttingCenters",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbCuttingCenter').append('<option value="' + res[i].bags_cutting_centers_id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}

    });
}

function allPurchaseOrder() {

    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allPurchaseOrder",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            //clear existing options
            $('#cmbPoNo').empty();
            var res = response.data.result;
            for (var i = 0; i < res.length; i++) {
                $('#cmbPoNo').append('<option value="' + res[i].external_id + '">' + res[i].external_id + '</option>');
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}

function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}

function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/bagsCuttingReturnMaxID", storeID);
    EXTERNAL_ID = referanceID;
    $('#txtExternal_id').val(referanceID);
}



function saveBagsCuttingReturn() {

    newReferanceID($('#cmbStores').val());
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();

    if (grn_data_arr.length == 0) {
        showWarningMessage("Invalid Dispatch Request (Empty list)");
        resetSaveButton();
        return;
    }

    for (var i = 0; i < grn_data_arr.length; i++) {
        if (!grn_data_arr[i][0]) {
            showWarningMessage("You should fill empty row in The list");
            resetSaveButton();
            return;
        }
        if (!grn_data_arr[i][5]) {
            showWarningMessage(grn_data_arr[i][1] + " Invalid Quantity");
            resetSaveButton();
            return;
        }
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][5], "comments": grn_data_arr[i][6], });
    }

    // Check for duplicate products
    var duplicates = findDuplicateProducts(grn_data_arr);
    if (duplicates.length > 0) {
        showWarningMessage('Duplicate products found: ' + duplicates.join(', '));
        resetSaveButton();
        return;
    }



    var quantity_invalied = false;

    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStores').val();
        var available_qty = parseFloat(getAvailableQuantitySaveBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            //disabled for now
            // quantity_invalied = true;
            // $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            // showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }


    if (quantity_invalied) {
        resetSaveButton();
        return;
    }

    $.ajax({
        type: "POST",
        url: '/sc/bagsCuttingReturnController/save',
        data: {
            'external_id': EXTERNAL_ID,
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'cutting_center_id': $('#cmbCuttingCenter').val(),
            
            'printing_damage': $('#txtPrintingDamage').val(),
            'seal_damage': $('#txtSealDamage').val(),
            'gazzet_isses': $('#txtGazzetIsses').val(),
            'other_damage': $('#txtOtherDamage').val(),
            'company_damage': $('#txtCompanyDamage').val(),
            'cutting_damage': $('#txtCuttingDamage').val(),
            'total_damage': $('#txtTotalDamage').val(),
            
            'store_id': $('#cmbStores').val(),
            'purchase_order_no': $('#cmbPoNo').val(),

            // 'supplier_Id': $('#txtSupplier').attr("data-id"),
            // 'received_by': $('#txtReceivedBy').val(),
            // 'supplier_ref_no': $('#txtSupplierRefNo').val(),
            // 'customer_order_plan_data_id': $('#cmbManufacturingOrder').val(),

            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': $('#txtRemarks').val(),
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            toastr.success('Data saved');
            location.href = '/sc/bags_cutting_return';
            
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
            resetSaveButton();
        },
        complete: function () {
        }

    });
}

function updateBagsCuttingReturn() {

    
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();
    for (var i = 0; i < grn_data_arr.length; i++) {
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][5], "comments": grn_data_arr[i][6], });
    }

    // Check for duplicate products
    var duplicates = findDuplicateProducts(grn_data_arr);
    if (duplicates.length > 0) {
        showWarningMessage('Duplicate products found: ' + duplicates.join(', '));
        resetSaveButton();
        return;
    }

    var quantity_invalied = false;

    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStores').val();
        var available_qty = parseFloat(getAvailableQuantitySaveBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            //disabled for now
            // quantity_invalied = true;
            // $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            // showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }

    if (quantity_invalied) {
        resetSaveButton();
        return;
    }
   
    $.ajax({
        type: "PUT",
        url: '/sc/bagsCuttingReturnController/update/' + GRN_ID,
        data: {
            'internal_id': GRN_ID,
            'external_id': EXTERNAL_ID,
            'ref_external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'cutting_center_id': $('#cmbCuttingCenter').val(),
            'printing_damage': $('#txtPrintingDamage').val(),
            'seal_damage': $('#txtSealDamage').val(),
            'gazzet_isses': $('#txtGazzetIsses').val(),
            'other_damage': $('#txtOtherDamage').val(),
            'company_damage': $('#txtCompanyDamage').val(),
            'cutting_damage': $('#txtCuttingDamage').val(),
            'total_damage': $('#txtTotalDamage').val(),
            'store_id': $('#cmbStores').val(),
            'purchase_order_no': $('#cmbPoNo').val(),
            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': $('#txtRemarks').val(),
            'grn_data': grn_data,

            // 'supplier_Id': $('#txtSupplier').attr("data-id"),
            // 'received_by': $('#txtReceivedBy').val(),
            // 'supplier_ref_no': $('#txtSupplierRefNo').val(),
            // 'customer_order_plan_data_id': $('#cmbManufacturingOrder').val(),
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            console.log(response);
            toastr.success('Data updated');
            location.href = '/sc/bags_cutting_return_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}

function getBagsCuttingReturn(id) {
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/getBagsCuttingReturn/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            GRN_ID = res.internal_id
            REFFERANCE_ID = res.external_id;
            EXTERNAL_ID = res.external_id;

            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            $('#cmbCuttingCenter').val(res.cutting_center_id);
            $('#cmbPoNo').val(res.purchase_order_no).trigger("change");
            $('#txtTransport_by').val(res.transport_by);
            $('#txtVehicle_no').val(res.vehicle_no);
            setSelectedOption("cmbStores", res.store_id);
            $('#txtPrintingDamage').val(res.printing_damage);
            $('#txtSealDamage').val(res.seal_damage);
            $('#txtGazzetIsses').val(res.gazzet_isses);
            $('#txtOtherDamage').val(res.other_damage);
            $('#txtCompanyDamage').val(res.company_damage);
            $('#txtCuttingDamage').val(res.cutting_damage);
            $('#txtTotalDamage').val(res.total_damage);
            $('#txtRemarks').val(res.remarks);
            
            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        { 'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'},
                        { 'type': 'string', 'val': getAvailableQty(request_data[i].product_primary_id, res.store_id), 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}






function getAvailableQty(product_id, store_id) {
    alert("product_id: " + product_id + ", store_id: " + store_id);
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}

function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            //console.log(res);
            //$('#txtReceivedBy').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}

function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allProductCustomer",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbManufacturingOrder').empty();
            for (var i = 0; i < res.length; i++) {
                var manufacturing_num = res[i].factory_po_num + '-' + res[i].product_name;
                $('#cmbManufacturingOrder').append('<option value="' + res[i].customer_order_plan_data_id + '">' + manufacturing_num + '</option>');
            }
        },
        error: function (error) {
            console.log(error);

        },
        complete: function () {

        }
    });
}

// Helper function to find duplicate products
function findDuplicateProducts(data_arr) {
    var products = {};
    var duplicates = [];

    for (var i = 0; i < data_arr.length; i++) {
        var product_id = data_arr[i][0];
        var product_name = data_arr[i][2];

        if (product_id) { // Only check if product_id exists
            var key = product_id + '_' + product_name;
            if (products[key]) {
                if (!duplicates.includes(product_name)) {
                    duplicates.push(product_name);
                }
            } else {
                products[key] = true;
            }
        }
    }

    return duplicates;
}

//disable the save button and show loading icon
function disableSaveButton() {
    $('#btnSave').prop('disabled', true);
    $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i>  Saving...');
}

//reset the save button to default state
function resetSaveButton() {
    $('#btnSave').prop('disabled', false);  
    $('#btnSave').html('Save');
}


function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}

function getProduct_Uom(id) {
    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}

function triggerRowInputs(id, selected_row) {

    if (id == "tblData") {
        var cells = selected_row.getElementsByTagName('td');
        var product = $('#' + cells[0].childNodes[0].id);
        var quantity = $('#' + cells[3].childNodes[0].id);
        quantity.on('input', function () {
            var av_qty = getAvailableQty(product.val(), $('#cmbStores').val());
            var qty = parseFloat(quantity.val());
            if (qty > av_qty) {
                showAlert("Available quantity is " + av_qty);
                quantity.val(av_qty);
            }
        });
    }

}

function showAlert(message) {
    swal({
        title: message,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    });

    $('.swal-button').on('click', function () {

    });

}


function allSuppliers() {
    var supplier_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            supplier_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return supplier_data;
}

function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/bagsCuttingReturnController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}

function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/bagsCuttingReturnController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Goods Return approved.");
                } else if (status == 2) {
                    toastr.success("Goods Return rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/bags_cutting_return_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}