$(document).ready(function () {

    var table = $('#tableMR').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "supplier" },
            { "data": "material_plant" },
            { "data": "date" },
            { "data": "item" },
            { "data": "quantity" },
            { "data": "edit" },
            { "data": "view" },
            { "data": "print"},
            { "data": "approve"},
            { "data": "delete", },
        ],
        columnDefs: [
            { width: 150, targets: 0 },
            { width: 100, targets: 2 },
            { width: 100, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 },
            { width: 30, targets: 8 },
            { width: 30, targets: 9 },
        ],
    });
    //table.column(7).visible(false);

    allGoodsReceivedMR();

});



function allGoodsReceivedMR() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrListController/allGoodsReceivedMR",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['refferance_no'];
                    var supplier_name = response.data.result[i]['supplier_name'];
                    var material_plant_name = response.data.result[i]['material_plant_name'];
                    var date = response.data.result[i]['trans_date'];
                    var item_name = response.data.result[i]['product_name'];
                    var wastage = response.data.result[i]['wastage'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    var disabled = "";
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                        disabled = "disabled";
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                        disabled = "disabled";
                    }

                    data.push({
                        "reference_no": reference_no,
                        "supplier": supplier_name,
                        "material_plant": material_plant_name,
                        "date": date,
                        "item": item_name,
                        "quantity": wastage,
                        "edit": '<button class="btn btn-primary" onclick="edit(' + string_id + ')" '+disabled+'><i class="fa fa-pencil" aria-hidden="true"></i></button>',
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "print": '<button class="btn btn-success" onclick="print(' + string_id + ')"><i class="fa fa-print" aria-hidden="true"></i></button>',
                        "approve": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="delete_confirmation(' + string_id + ')" '+disabled+'><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#tableMR').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function edit(id) {
    location.href = "/sc/goods_received_mr?id=" + id + "&action=edit";
}



function view(id) {
    location.href = "/sc/goods_received_mr?id=" + id + "&action=view";
}



function _delete(id){

    $.ajax({
        type: 'DELETE',
        url: '/sc/GoodsReceivedMrListController/delete/' + id,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage("Data has been deleted successfully...")
                allGoodsReceivedMR();
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();
        },
        complete: function () {

        }

    }); 
}


function delete_confirmation(id) {
    swal({
        title: "Are you sure want delete?",
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                _delete(id);
            }
        });

}


function print(id) {

    $.ajax({
        type: "GET",
        url: "/sc/GoodsReceivedMrListController/goodsReceivedMRReport/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //$('.btn').prop("disabled", true);
            //document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;
            goodsReceivedPrint(result, 'PRINT');

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            //$('#btnPrint').text('Print');
            //$('.btn').prop("disabled", false);
        }

    });

}


function goodsReceivedPrint(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];

    var header_data = result.header;


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName(), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Goods Received MR', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{
                                table: {
                                    widths: ['*', 150],
                                    headerRows: 1,
                                    body: [
                                        [{ text: 'Supplier : ' + header_data.supplier, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Referance No : ' + header_data.referance_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Received By : ' + header_data.received_by, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Date : ' + header_data.date, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'No Of Items :' + header_data.no_of_items, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Store : ' + header_data.store, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'First Weight :'+ header_data.first_weight, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Supplier Ref No : ' + header_data.supplier_ref_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'First Weight Time :'+ header_data.first_weight_time, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'PO No. : ' + header_data.po_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Second Weight :'+ header_data.second_weight, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Transport By : ' + header_data.transport_by, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Second Weight Time :'+ header_data.second_weight_time, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Vehicle No : ' + header_data.vehicle_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Net Weight :'+ header_data.net_weight, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Finders : ' + header_data.finders, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Volume :'+ header_data.volume, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'No Of Bags : ' + header_data.no_of_bags, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Driver Name :'+ header_data.driver_name, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Weigh Bill No : ' + header_data.weigh_bill_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Wastage :'+ header_data.wastage, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Moisture : ' + header_data.moisture, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: 'Sand :'+ header_data.sand, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Ec Level : ' + header_data.ec_level, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],

                                    ],

                                }, border: [false, false, false, false]
                            }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var footer_data = result.header;
    var Body = [
        {
            table: {
                widths: [50, '*', 50, 50, 100,100],
                headerRows: 1,
                body: goodsReceivedPrintBody(result.body),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },
        },
        {
            table: {
                widths: ['*', 100],
                headerRows: 0,

                body: [
                    [
                        { text: 'Total :', fontSize: 9, bold: false, alignment: 'right', border: [false, true, false, true], margin: [0, 0, 0, 0], colSpan: 1 },
                        { text: parseFloat(result.header.total_value).toFixed(2), fontSize: 9, bold: false, alignment: 'right', border: [false, true, false, true], margin: [0, 0, 0, 0] },

                    ],


                ],
            },
        },
       
        { text: '', margin: [5, 2, 10, 20] },
        {
            table: {
                widths: [100, 100, 100, 100, '*'],
                headerRows: 1,

                body: [
                    [
                        { text: 'Prepared By', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },
                        { text: 'Checked By', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },
                        { text: 'Received By', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },
                        { text: 'Authorized By', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false], margin: [0, 0, 0, 15] },
                    ],
                    [
                        { text: '..................................', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false] },
                        { text: '..................................', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false] },
                        { text: '..................................', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false] },
                        { text: '', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false] },
                        { text: '..................................', fontSize: 9, bold: false, alignment: 'center', border: [false, false, false, false] },
                    ],


                ],
            },


        },

    ];




    var Footer = [

        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function goodsReceivedPrintBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Unit', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Price', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Value', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    var data = result.data;
    for (i = 0; i < data.length; i++) {
        body.push([
            { text: data[i].product_id, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: data[i].product, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: data[i].unit, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: parseFloat(data[i].quantity).toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, false] },
            { text: parseFloat(data[i].price).toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, false] },
            { text: parseFloat(data[i].value).toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, false] },
        ]);
    }

    return body;
}




/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}
