var MR_ID = 0;
$(document).ready(function () {

    var table = $('#tblMr').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "id" },
            { "data": "date" },
            { "data": "referance_no" },
            { "data": "store" },
            { "data": "department" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 100, targets: 1 },
            { width: 100, targets: 2 },
        ],
    });
    table.column(0).visible(false);

    $('#btnRetrieveMR').on('click', function () {

        table.column(0).visible(false);
        retrieveMrHeader();
    });




    $('#tblMr tbody').on('click', 'tr', function () {
        table.column(0).visible(true);
        $(this).addClass('selected').siblings().removeClass('selected');
        MR_ID = $(this).find('td:first').html();
        table.column(0).visible(false);
        retrieveMrData(MR_ID);
    });


    $('#btnGetDataMR').on('click',function(){
        $('#mrDataModal').modal('hide');
        setSelectedMR(MR_ID);
    });
});


function retrieveMrHeader() {

    $.ajax({
        type: "GET",
        url: "/sc/RetrieveMRBagsController/allMaterialRequisition",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                console.log(response);
                var data = [];
                $('#tblBopdyMrData').empty();
                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var refferance_id = response.data.result[i]['external_id'];
                    var date = response.data.result[i]['trans_date'];
                    var store = response.data.result[i]['store'];
                    var department = response.data.result[i]['department'];

                    /*var row = '<tr><td hidden>' + id + '</td>';
                    row += '<td>' + date + '</td>';
                    row += '<td>' + refferance_id + '</td>';
                    row += '<td>' + store + '</td>';
                    row += '<td>' + department + '</td></tr>';
                    $('#tblBodyMrHeader').append(row);*/


                    data.push({
                        "id": id,
                        "date": date,
                        "referance_no": refferance_id,
                        "store": store,
                        "department": department,
                    });

                }

                var table = $('#tblMr').DataTable();
                table.clear();
                table.rows.add(data).draw();

            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {
            $('#mrDataModal').modal('show');
        }

    });

}




function retrieveMrData(id) {

    $.ajax({
        type: "GET",
        url: "/sc/RetrieveMRBagsController/allMaterialRequisitionData/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {

                console.log(response);
                $('#tblBopdyMrData').empty();
                for (i = 0; i < response.data.result.length; i++) {
                    var mr_data_id = response.data.result[i]['mr_data_id'];
                    var product_id = response.data.result[i]['product_id'];
                    var product_name = response.data.result[i]['product_name'];
                    var quantity = response.data.result[i]['quantity'];
                    var unit = response.data.result[i]['unit'];
                    var reject = '<button class="btn btn-danger" onclick="reject('+mr_data_id+')">Reject</button>';

                    var row = '<tr><td>' + product_id + '</td>';
                    row += '<td>' + product_name + '</td>';
                    row += '<td>' + quantity + '</td>';
                    row += '<td>' + unit + '</td>';
                    row += '<td>' + reject + '</td></tr>';
                    $('#tblBopdyMrData').append(row);

                }


            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {
            $('#mrDataModal').modal('show');
        }

    });

}




function setSelectedMR(id) {

    $.ajax({
        type: "GET",
        url: "/sc/RetrieveMRBagsController/getSelectedMR/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            GOODS_TRANSFER_ID = res.internal_id
            //referanceID = res.external_id;
            //$('#txtExternal_id').val(res.external_id);
            //$('#txtGrnDate').val(res.trans_date);
            //setSelectedOption('cmbStoresFrom', res.store_from_id);
            setSelectedOption('cmbStoresTo', res.store_id);
            $("#cmbManufacturingOrder").val(res.customer_order_plan_data_id).trigger("change");
            tableData.clear();
            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': getAvailableQty(request_data[i].product_primary_id,$('#cmbStoresTo').val()), 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            progress(false);
        }

    });
}




function reject(id){
    change_status_confirmation(id,2,"Are you sure want to Reject?");
}

function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_statusxxx(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/RetrieveMRBagsController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () { 
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                showSuccessMessage('Rejected.');
                retrieveMrData(MR_ID);
            } 
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
            if ($('#tblBopdyMrData tr').length <= 1) {
                retrieveMrHeader();
            }
        }

    });
}