
var action = "save";
var tableData = undefined;
var GOODS_TRANSFER_ID = undefined;
var referanceID = undefined;
const TOKEN = Math.floor(Math.random() * 212345);
$(document).ready(function () {
    $('.status_btn').hide();
    $('#cmbPO').select2();
    $('#cmbManufacturingOrder').select2();

    $('#tblGRNAttachment').DataTable({
        responsive: true,
        "order": [],
        "columns": [
            { "data": "file" },
            { "data": "view" },
            { "data": "download" },
            { "data": "delete" },
        ],
        columnDefs: [
            { width: 80, targets: 1 },
            { width: 80, targets: 2 },
            { width: 80, targets: 3 },
        ],
    });

    $('#btnAttachment').on('click', function () {
        $('#attachmentAddModal').modal('toggle');
        //showWarningMessage('Please save purchase order to before upload attachmnet...!');
    });

    var supplierChooser = $('#supplierChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 300, targets: 1 },
        ],
    });

    var supplier_data = allSuppliers();
    console.log(supplier_data);
    supplierChooser.setDataSource(supplier_data);

    supplierChooser.on('select', function (event, data) {
        $('#txtSupplier').val(data[1]);
        $('#txtSupplier').attr("data-id", data[0]);
        var input = supplierChooser.getInput();
        input.focus();
        getPoFromSupplier(data[0]);
    });

    var productChooser = $('#productChooser').dataChooser({
        "columns": [
            { "data": "id" },
            { "data": "value0" },
            { "data": "value1" },
        ],
        columnDefs: [
            { width: 50, targets: 0 },
            { width: 200, targets: 1 },
            { width: 300, targets: 2 },
        ],
    });

    var product_data = allProduct();
    console.log(product_data);
    productChooser.setDataSource(product_data);

    $('#attachmnet_token').val(TOKEN);

    tableData = $('#tblData').transactionTable({
        thead: ['ProductPrimaryID', 'ProductID', 'Product Name', 'Unit', 'Available Qty', 'Qty', 'Comments', 'Remove'],
        data_chooser: [{ 'col': 2 }],
        chooser: productChooser,
        column_def: { 1: 100 },
        auto_focus: 2,
        row_type: [
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'string', 'value': '', 'align': 'left', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '100%' },
            {
                'type': 'select', 'value': [], 'align': 'left', 'width': '100px'
            },
            { 'type': 'string', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'right', 'width': '100px' },
            { 'type': 'text', 'value': '', 'align': 'left', 'width': '200px' },
            { 'type': 'remove', 'value': 'X', 'align': 'center', 'width': '50px' }],
    });

    productChooser.on('select', function (event, data) {
        var selected_row = tableData.getSelectedRow();
        var cells = selected_row.getElementsByTagName('td');
        cells[0].childNodes[0].value = data[0];
        cells[1].childNodes[0].value = data[1];
        cells[2].childNodes[0].value = data[2];
        cells[4].childNodes[0].value = getAvailableQty(data[0], $('#cmbStoresFrom').val());
        var input = productChooser.getInput();
        input.focus();

        var product_id = data[0];
        var uom = getProduct_Uom(product_id);
        $('#' + cells[3].childNodes[0].id).empty();
        $('#' + cells[3].childNodes[0].id).append('<option value="' + uom.id + '">' + uom.value + '</option>');
    });

    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    $('input[name="deliverBeforeDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });

    $('input[name="firstWeightTime"]').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        locale: {
            format: 'YYYY-MM-DD hh:mm:ss'
        }
    });

    $('input[name="secondWeightTime"]').daterangepicker({
        singleDatePicker: true,
        timePicker: true,
        startDate: moment().startOf('hour'),
        endDate: moment().startOf('hour').add(32, 'hour'),
        locale: {
            format: 'YYYY-MM-DD hh:mm:ss'
        }
    });
   
    //allPurchaseOrders();
    allManufacturingOrder();
    allStores();
    newReferanceID($('#cmbStoresFrom').val());

    $('#cmbStoresFrom').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#btnSave').on('click', function () {

        if ($(this).text() == 'Save') {
            saveGoodsTransfer();
        } else {
            if (!isApproved()) {
                updateGoodsTransfer();
            } else {
                showWarningMessage('This Goods transfer Cannot be update...!');
            }
        }
    });


    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        GOODS_TRANSFER_ID = id;
        getGoodsTransfer(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
            $('.status_btn').hide();
        } else if (action == 'view') {
            $('#btnSave').hide();
            $('.status_btn').show();
        }

    } else {
        tableData.add_empty_row();
        transactionTimeout(60000);//5MINUTES
    }

    $('#txtSupplier').on('input', function () {
        supplierChooser.showChooser($('#txtSupplier'));
    });

    $('#txtDiscountPresentage').on('input', function () {
        overallCalculation();
    });

    $('#btnApprove').on('click', function () {
        change_status_confirmation(GOODS_TRANSFER_ID, 1, "Are you sure want to approve?");
    });
    $('#btnReject').on('click', function () {
        change_status_confirmation(GOODS_TRANSFER_ID, 2, "Are you sure want to reject?");
    });

});

Dropzone.options.myDropzone = {
    dictDefaultMessage: 'Drop file here or click to upload!!!!!!!!',
    addRemoveLinks: true,
    init: function () {
        this.on("complete", function (file) {
            allAttachment(1, TOKEN);
        });
    }
};


//updated functions 
function allManufacturingOrder() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getScheduledFactoryPO",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            var res = response.data.result;
           
             // Clear and append options
            $('#cmbManufacturingOrder').empty();
            for (var i = 0; i < res.length; i++) {
                var manufacturing_num = res[i].factory_po_num + '-' + res[i].product_name;
                $('#cmbManufacturingOrder').append(
                    $('<option>', {
                        value: res[i].customer_order_plan_id,
                        text: manufacturing_num
                    })
                );
            }

            // Refresh Select2
            $('#cmbManufacturingOrder').trigger('change');
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {}

    });
}

function allPurchaseOrders() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/allPurchaseOrders",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#cmbPO').empty();
            $('#cmbPO').append('<option value="">Select Purchase Order</option>');
            for (var i = 0; i < res.length; i++) {
                let select_data = res[i].external_id +' - ' + res[i].supplier_name;
                $('#cmbPO').append('<option value="' + res[i].external_id + '">' + select_data + '</option>');
            }
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {
        }
    });
}

function computeNetWeight(){
    
    var f_weight = parseFloat($('#txtFirstWeight').val());
    var s_weight = parseFloat($('#txtSecondWeight').val());

    var n_weight = 0;
    $('#txtNetWeight').val(n_weight);

    if(!isNaN(f_weight) && !isNaN(s_weight)){
        n_weight = f_weight - s_weight;
    }

    if(!isNaN(n_weight)){
        $('#txtNetWeight').val(Math.abs(n_weight));
    }else{
        $('#txtNetWeight').val(0);
    }
}


function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStoresFrom').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
                $('#cmbStoresTo').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}






function newReferanceID(storeID) {
    referanceID = newID("/sc/ReferenceIDController/goodsTransferMRMaxID", storeID);
    $('#txtExternal_id').val(referanceID);
}






function allProduct() {
    var product_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/allProduct",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            product_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });

    return product_data;
}




function allSuppliers() {
    var supplier_data = [];
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/allSuppliers",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            supplier_data = response.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return supplier_data;
}




function saveGoodsTransfer() {

    newReferanceID($('#cmbStoresFrom').val());
    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        return;
    }
    if ($('#txtReceivedBy').attr("data-id") == '' || $('#txtRequestBy').val() == '') {
        showWarningMessage("Please Select Received By");
        return;
    }
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();
    if (grn_data_arr.length == 0) {
        showWarningMessage("Invalied Grn (Empty list)");
        return;
    }
    for (var i = 0; i < grn_data_arr.length; i++) {
        if (!grn_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][5], "comments": grn_data_arr[i][6], });
    }



    var quantity_invalied = false;

    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStoresFrom').val();
        var available_qty = parseFloat(getAvailableQuantitySaveBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            quantity_invalied = true;
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }


    if (quantity_invalied) {
        return;
    }


    $.ajax({
        type: "POST",
        url: '/sc/GoodsTransferMRController/save',
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_extenal_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'store_from_id': $('#cmbStoresFrom').val(),
            'store_to_id': $('#cmbStoresTo').val(),
            'first_weight': $('#txtFirstWeight').val(),
            'second_weight': $('#txtSecondWeight').val(),
            'first_weight_time': $('#txtFirstWeightTime').val(),
            'second_weight_time': $('#txtSecondWeightTime').val(),
            'net_weight': $('#txtNetWeight').val(),
            'po_no': $('#cmbPO').val(),
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'vehicle_no': $('#txtVehicleNO').val(),
            'finders': $('#txtFinders').val(),
            'volume': $('#txtVolume').val(),
            'no_of_bags': $('#txtNoOfBags').val(),
            'driver_name': $('#txtDriver').val(),
            'weigh_bill_no': $('#txtWeighBillNo').val(),
            'received_by': $('#txtReceivedBy').attr("data-id"),
            'supplier_id': $('#txtSupplier').attr("data-id"),
            'comment': $('#txtComment').val(),
            'wastage': $('#txtWastage').val(),
            'moisture': $('#txtMoisture').val(),
            'sand': $('#txtSand').val(),
            'ec_level': $('#txtEClevel').val(),
            'mr_internal_id': MR_ID,
            'attachment_token': TOKEN,
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data saved');
                location.href = '/sc/goods_transfer_mr';
            } else {
                showErrorMessage();
            }
            //location.reload();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getGoodsTransfer(id) {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getGoodsTransfer/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            progress(true);
        },
        success: function (response) {
            var res = response.data.result;
            GOODS_TRANSFER_ID = res.internal_id
            //referanceID = res.external_id;
            $('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            setSelectedOption('cmbStoresFrom', res.store_from_id);
            //setSelectedOption('cmbStoresTo', res.store_to_id);
            $('#cmbStoresTo').val(res.store_to_id);
            $('#txtFirstWeight').val(res.first_weight);
            $('#txtFirstWeightTime').val(res.first_weight_time);
            $('#txtSecondWeight').val(res.second_weight);
            $('#txtSecondWeightTime').val(res.second_weight_time);
            $('#txtNetWeight').val(res.net_weight);
            $("#cmbPO").val(res.po_no).trigger("change");
            $("#cmbManufacturingOrder").val(res.customer_order_plan_id).trigger("change");
            $('#txtVehicleNO').val(res.vehicle_no);
            $('#txtFinders').val(res.finders);
            $('#txtVolume').val(res.volume);
            $('#txtNoOfBags').val(res.no_of_bags);
            $('#txtDriver').val(res.driver_name);
            $('#txtWeighBillNo').val(res.weigh_bill_no);
            $('#txtComment').val(res.comment);
            $('#txtWastage').val(res.wastage);
            $('#txtMoisture').val(res.moisture);
            $('#txtSand').val(res.sand);
            $('#txtEClevel').val(res.ec_level);
           

            var request_data = res.data;
            for (var i = 0; i < request_data.length; i++) {
                tableData.addRow(
                    [
                        { 'type': 'string', 'val': request_data[i].product_primary_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'string', 'val': request_data[i].product_id, 'align': 'left', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].product, 'align': 'left', 'width': '100%' },
                        {
                            'type': 'select', 'val': request_data[i].uom, 'align': 'left', 'width': '100px'
                        },
                        { 'type': 'text', 'val': parseFloat(getAvailableQty(request_data[i].product_primary_id, $('#cmbStoresFrom').val())) + parseFloat(request_data[i].quantity), 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].quantity, 'align': 'right', 'width': '100px' },
                        { 'type': 'text', 'val': request_data[i].comments, 'align': 'left', 'width': '200px' },
                        { 'type': 'remove', 'val': 'X', 'align': 'center', 'width': '50px' }]
                );
            }

            allAttachment(id, 0);

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {
            progress(false);
        }

    });
}

function updateGoodsTransfer() {

    if ($('#txtSupplier').attr("data-id") == '' || $('#txtSupplier').val() == '') {
        showWarningMessage("Please Select Supplier");
        return;
    }
    if ($('#txtReceivedBy').attr("data-id") == '' || $('#txtReceivedBy').val() == '') {
        showWarningMessage("Please Select Received By");
        return;
    }
    var grn_data = {};
    var grn_data_arr = tableData.dataSource();
    if (grn_data_arr.length == 0) {
        showWarningMessage("Invalied Grn (Empty list)");
        return;
    }
    for (var i = 0; i < grn_data_arr.length; i++) {
        if (!grn_data_arr[i][0]) {
            showWarningMessage("You shuld fill empty row in The list");
            return;
        }
        grn_data[i] = JSON.stringify({ "product_id": grn_data_arr[i][0], "product_name": grn_data_arr[i][2], "unit_id": grn_data_arr[i][3], "qty": grn_data_arr[i][5], "comments": grn_data_arr[i][6], });
    }

    if (GOODS_TRANSFER_ID == undefined) {
        showWarningMessage('Grn not selected...!');
        return;
    }




    var quantity_invalied = false;

    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStoresFrom').val();
        var available_qty = parseFloat(getAvailableQuantityUpdateBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            quantity_invalied = true;
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }

    if (quantity_invalied) {
        return;
    }


    if (!isValiedToUpdate(GOODS_TRANSFER_ID)) {
        showWarningMessage('Goods already issued.');
        return;
    }


    $.ajax({
        type: "PUT",
        url: '/sc/GoodsTransferMRController/update/' + GOODS_TRANSFER_ID,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'ref_extenal_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'store_from_id': $('#cmbStoresFrom').val(),
            'store_to_id': $('#cmbStoresTo').val(),
            'first_weight': $('#txtFirstWeight').val(),
            'second_weight': $('#txtSecondWeight').val(),
            'first_weight_time': $('#txtFirstWeightTime').val(),
            'second_weight_time': $('#txtSecondWeightTime').val(),

            'net_weight': $('#txtNetWeight').val(),
            'po_no': $('#cmbPO').val(),
            'customer_order_plan_id': $('#cmbManufacturingOrder').val(),
            'vehicle_no': $('#txtVehicleNO').val(),
            'finders': $('#txtFinders').val(),
            'volume': $('#txtVolume').val(),
            'no_of_bags': $('#txtNoOfBags').val(),
            'driver_name': $('#txtDriver').val(),
            'weigh_bill_no': $('#txtWeighBillNo').val(),
            'received_by': $('#txtReceivedBy').attr("data-id"),
            'supplier_id': $('#txtSupplier').attr("data-id"),
            'comment': $('#txtComment').val(),
            'wastage': $('#txtWastage').val(),
            'moisture': $('#txtMoisture').val(),
            'sand': $('#txtSand').val(),
            'ec_level': $('#txtEClevel').val(),

            'attachment_token': TOKEN,
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
           // $('#btnSave').html('<i class="fa fa-circle-o-notch fa-spin"></i>');
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                toastr.success('data updated');
                location.href = '/sc/goods_transfer_mr_list';
            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}

function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function triggerRowInputs(id, selected_row) {






}




function transactionTableUpdate(table_id) { // override function from transaction_table.js

}



function getProduct_Uom(id) {

    var unit = undefined;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getUom/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            unit = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return unit;
}



function transactionTimeout(minutes) {

    setInterval(function () {
        if (tableData.getTransactionDelay() > minutes) {
            tableData.reset();
        }
    }, minutes);
}



function allAttachment(id, token) {
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/allAttachment/" + id + "/" + token,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                var result = response.data.result;
                var data = [];
                for (var i = 0; i < result.length; i++) {
                    var path = "'" + result[i].path + "'";
                    var id = "'" + result[i].purchase_order_attachment_id + "'";
                    data.push({
                        "file": result[i].path,
                        "view": '<button type= "button" class="btn btn-primary" onclick="viewAttachment(' + path + ');"><i class="fa fa-eye" aria-hidden="true"></i></button> ',
                        "download": '<button type= "button" class="btn btn-success" onclick="downloadAttachment(' + path + ');"><i class="fa fa-download" aria-hidden="true"></i></button> ',
                        "delete": '<button type= "button" class="btn btn-danger" onclick="deleteAttachment(' + id + ');"><i class="fa fa-trash" aria-hidden="true"></i></button> ',
                    });
                }
                var table = $('#tblGRNAttachment').DataTable();
                //table.clear();
                table.rows.add(data).draw();
            } else {
                showErrorMessage();
            }

        },
        error: function (error) {
            console.log(error);

        },

    });
}


function viewAttachment(file) {
    window.open('/grn/' + file);

}


function downloadAttachment(file) {
    var link = document.createElement("a");
    link.download = file;
    link.href = "/grn/" + file;
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    delete link;
}


function getPoFromSupplier(id) {

    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getPoFromSupplier/" + id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            var res = response.data.result;
            for (var i = 0; i < res.length; i++) {
                $('#cmbPoNo').append('<option value="' + res[i].external_id + '">' + res[i].external_id + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}


function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}




function getAvailableQtyUpdate(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/getQtyUpdate/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}




function isApproved() {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/isApproved/" + GOODS_TRANSFER_ID,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            bool = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;

}



function isValiedToUpdate() {

    var bool = false;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferMRController/isValiedToUpdate/" + GOODS_TRANSFER_ID,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            bool = response.canUpdate;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return bool;

}




function change_status_confirmation(id, status, msg) {
    swal({
        title: msg,
        //text: "Once deleted, you will not be able to recover this record!",
        icon: "warning",
        buttons: {
            yes: {
                text: "Yes",
                value: true,
                className: 'btn btn-danger',
            },
            no: {
                text: "No",
                value: false,
                className: 'btn btn-primary',
            }
        },

    })
        .then((willDelete) => {
            if (willDelete) {
                change_status(id, status);
            }
        });

}

function change_status(id, status) {

    $.ajax({
        type: "PUT",
        url: '/sc/GoodsTransferMRController/change_status/' + id,
        data: {
            status: status,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
            // document.getElementById('btnApproveGrn').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            if (response.data.success) {
                if (status == 1) {
                    toastr.success("Goods Transfer M.R approved.");
                } else if (status == 2) {
                    toastr.success("Goods Transfer M.R rejected.");
                }

            } else {
                showErrorMessage();
            }
            location.href = '/sc/goods_transfer_mr_list';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
            // document.getElementById('approve'+id).innerHTML = '<i class="fa fa-times" aria-hidden="true"></i>';
        }

    });
}



/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}


function computeNetWeight(){
    
    var f_weight = parseFloat($('#txtFirstWeight').val());
    var s_weight = parseFloat($('#txtSecondWeight').val());

    var n_weight = 0;
    $('#txtNetWeight').val(n_weight);

    if(!isNaN(f_weight) && !isNaN(s_weight)){
        n_weight = f_weight - s_weight;
    }

    if(!isNaN(n_weight)){
        $('#txtNetWeight').val(Math.abs(n_weight));
    }else{
        $('#txtNetWeight').val(0);
    }
}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}