
var tbl = null;
var RAND_ID = undefined;
var grn_id = 0;
var action = "save";
var referanceID = undefined;
var is_grn = false;
var external_id = undefined;
var save_keycode = 0;

document.addEventListener('keydown', keydownevent);

function keydownevent(e) {
    if (e.keyCode == 16) {
        save_keycode = 16;
    }
    if (e.keyCode == 13) {
        save_keycode = save_keycode + "" + 13;
        if(save_keycode == '1613'){
            saveGrnHeader();
        }
    }
}



$(document).ready(function () {
    $('input[name="trans_date"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });


    tbl = $('#tBody').grnTable({
        column_def: {
            product_id: { align: "left", datachooser: 'off', width: '80px', editable: false, type: 'text' },
            product_name: { align: "left", datachooser: 'on', width: '300px', editable: true, type: 'text' },
            unit_id: { align: "right", datachooser: 'off', width: '150px', editable: true, type: 'select' },
            quantity: { align: "right", datachooser: 'off', width: '80px', editable: true, type: 'text' },
            available_quantity: { align: "right", datachooser: 'off', width: '80px', editable: false, type: 'text' },
            comments: { align: "left", datachooser: 'off', width: '280px', editable: true, type: 'text' },
            delete: { align: "left", datachooser: 'off', width: '100%', editable: false, type: 'button' },
        },
        on_focus: 'product_name'


    });



    var supplerChooser = $('#supplierChooser').dataChooser({
        title: 'Supplier List',
        action: 'Select',

    });

    var grnChooser = $('#grnChooser').dataChooser({
        title: 'GRN List',
        action: 'Select',

    });


    supplerChooser.on('select', function (event, id, value) {
        $('#txtSupplier').val(value);
        $('#txtSupplier').attr("data-id", id);
        var resp = $('#supplierChooser').hideChooser();
        if (resp) {
            $('#txtSupplier').focus();
        }

    });

    grnChooser.on('select', function (event, id, value) {
        $('#txtgrn_id').val(id);
        //$('#txtExternal_id').val(id);
        $('#grnChooser').hideChooser();
        getGrn(id);


    });

    allEmployees();
    allSuppliers();
    allStores();
    allGrn();
    newReferanceID($('#cmbStores').val());

    $('#btnSave').on('click', function () {

        if ($(this).text() == 'Save') {
            saveGrnHeader();
        } else {
            updateGrnHeader();
        }
    });



    if (window.location.search.length > 0) {
        var sPageURL = window.location.search.substring(1);
        var param = sPageURL.split('?');
        var id = param[0].split('=')[1].split('&')[0];
        action = param[0].split('=')[2].split('&')[0];
        getGrn(id);
        if (action == 'edit') {
            $('#btnSave').text('Update');
        } else if (action == 'view') {
            $('#btnSave').hide();
        }

    } else {
        tbl.setStatus(TABLE_ADD);
        tbl.addRow();
        $('#btnSave').text('Save');
    }



    $('#cmbStores').on('change', function () {
        newReferanceID($(this).val());
    });

    $('#txtSupplier').on('input', function () {
        $('#supplierChooser').showChooser($('#txtSupplier').val());
    });



    $('#txtgrn_id').on('input', function () {
        $('#grnChooser').showChooser($(this).val());
    });

    $('#supplierChooser').on('shown.bs.modal', function (e) {
        $("#search_supplierChooser").focus(); //datachooser modal search input
    });

    $('#grnChooser').on('shown.bs.modal', function (e) {
        $("#search_grnChooser").focus(); //datachooser modal search input
    });

});


/*function randID() {
    var id = 0;
    $.ajax({
        type: "GET",
        url: "/sc/grnHeaderController/getRandID",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            id = response.data.result;
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
    return id;
}*/


//Received By
function allEmployees() {
    $.ajax({
        type: "GET",
        url: "/sc/grnReturnController/allEmployees",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            $('#txtReceivedBy').setData(res);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allSuppliers() {
    $.ajax({
        type: "GET",
        url: "/sc/grnReturnController/allSuppliers",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            $('#supplierChooser').setDatasource(response.result);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allGrn() {
    $.ajax({
        type: "GET",
        url: "/sc/grnReturnController/allGrn",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            $('#grnChooser').setDatasource(response.result);
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function allStores() {
    $.ajax({
        type: "GET",
        url: "/sc/grnReturnController/allStores",
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            for (var i = 0; i < res.length; i++) {
                $('#cmbStores').append('<option value="' + res[i].id + '">' + res[i].name + '</option>');
            }
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}




function newReferanceID(storeID) {
    var referanceID = newID("/sc/ReferenceIDController/grnReturnMaxID",storeID);
    external_id = referanceID;
    $('#txtExternal_id').val(referanceID);
}



function saveGrnHeader() {


    var grn_data = {};

    for (var i = 0; i < tbl.rowCount(); i++) {
        grn_data[i] = { "product_id": tbl.getVal(i, 0), "product_name": tbl.getVal(i, 1), "unit_id": tbl.getVal(i, 2), "qty": tbl.getVal(i, 3), "comments": tbl.getVal(i, 5), };
    }



    var ref_external_id = external_id;
    if (is_grn) {
        ref_external_id = $('#txtExternal_id').val();
    }



    var quantity_invalied = false;

    var row_count = $('#tblData >tr').length;
    for (var i = 1; i < row_count; i++) {
        var product_id = $('#tblData >tr').eq(i).find("td :input").eq(0).val();
        var store_id = $('#cmbStores').val();
        var available_qty = parseFloat(getAvailableQuantitySaveBefore(product_id, store_id));
        $('#tblData >tr').eq(i).find("td :input").eq(4).val(available_qty);
        if (isNaN(available_qty)) {
            available_qty = 0;
        }

        var qty = parseFloat($('#tblData >tr').eq(i).find("td :input").eq(5).val());
        if (isNaN(qty)) {
            qty = 0;
            $('#tblData >tr').eq(i).find("td :input").eq(5).val(0);
        }

        if (available_qty < qty) {
            quantity_invalied = true;
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "red");
            showWarningMessage('Stock balance  is insufficient');
        } else {
            $('#tblData >tr').eq(i).find("td :input").eq(5).css("background-color", "white");
        }

    }


    if (quantity_invalied) {
        return;
    }

    $.ajax({
        type: "POST",
        url: '/sc/grnReturnController/save',
        data: {
            'internal_id': grn_id,
            'external_id': external_id,
            'ref_external_id': ref_external_id,
            'trans_date': $('#txtGrnDate').val(),
            'supplier_Id': $('#txtSupplier').attr("data-id"),
            'received_by': $('#txtReceivedBy').optionID(),
            'store_id': $('#cmbStores').val(),
            'supplier_ref_no': $('#txtSupplierRefNo').val(),
            'purchase_order_no': $('#txtPurchase_order_no').val(),
            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': '',
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data saved');
            tbl.reset();

        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}



function getGrn(id) {
    tbl.reset();
    $.ajax({
        type: "GET",
        url: "/sc/grnReturnController/getGrn/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            var res = response.data.result;
            console.log(res);
            grn_id = res.internal_id
            referanceID = res.external_id;
            //$('#txtExternal_id').val(res.external_id);
            $('#txtGrnDate').val(res.trans_date);
            $('#txtSupplier').attr("data-id", res.supplier_Id);
            $('#txtSupplier').val(res.supplier);
            $('#txtReceivedBy').attr("data-id", res.received_by);
            $('#txtReceivedBy').val(res.received);
            setSelectedOption('cmbStores', res.store_id);
            $('#txtSupplierRefNo').val(res.supplier_ref_no);
            $('#txtPurchase_order_no').val(res.purchase_order_no);
            $('#txtTransport_by').val(res.transport_by);
            $('#txtVehicle_no').val(res.vehicle_no);
            is_grn = true;
            var grn_data = res.data;
            for (var i = 0; i < grn_data.length; i++) {
                tbl.setStatus(TABLE_ADD);
                tbl.addRow();
                $('#' + i + '_0').val(grn_data[i].product_id);
                $('#' + i + '_1').val(grn_data[i].product);
                setSelectedOption(i + '_2', grn_data[i].unit_id);
                $('#' + i + '_3').val(grn_data[i].quantity);
                $('#' + i + '_4').val(grn_data[i].quantity);
                $('#' + i + '_5').val(grn_data[i].comments);
                tbl.setStatus(TABLE_ADD);
                $('#' + i + '_5').focus();

            }

        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function updateGrnHeader() {

    var grn_data = {};

    for (var i = 0; i < tbl.rowCount(); i++) {
        grn_data[i] = { "product_id": tbl.getVal(i, 0), "product_name": tbl.getVal(i, 1), "unit_id": tbl.getVal(i, 2), "qty": tbl.getVal(i, 3), "comments": tbl.getVal(i, 4), };
    }

    $.ajax({
        type: "PUT",
        url: '/sc/grnReturnController/update/' + grn_id,
        data: {
            'external_id': $('#txtExternal_id').val(),
            'trans_date': $('#txtGrnDate').val(),
            'supplier_Id': $('#txtSupplier').attr("data-id"),
            'received_by': $('#txtReceivedBy').optionID(),
            'store_id': $('#cmbStores').val(),
            'supplier_ref_no': $('#txtSupplierRefNo').val(),
            'purchase_order_no': $('#txtPurchase_order_no').val(),
            'transport_by': $('#txtTransport_by').val(),
            'vehicle_no': $('#txtVehicle_no').val(),
            'remarks': '',
            'grn_data': grn_data,
        },
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        timeout: 800000,
        beforeSend: function () {
        },
        success: function (response) {
            console.log(response);
            toastr.success('data updated');
            location.href = '/sc/grnList';
        },
        error: function (error) {
            console.log(error);
            toastr.error('Something went wrong');
        },
        complete: function () {
        }

    });
}





function setSelectedOption(id, valueToSelect) {
    let element = document.getElementById(id);
    element.value = valueToSelect;
}


function getAvailableQty(product_id, store_id) {
    var qty = 0;
    $.ajax({
        type: "GET",
        url: "/sc/GoodsTransferController/getQty/" + product_id + "/" + store_id,
        async: false,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);
            qty = response.data.result;
        },
        error: function (error) {
            console.log(error);
        },
        complete: function () {

        }

    });
    return qty;
}


/**
* generateID
* This function is used to generate id
* @param id This is the paramter to require id
*/
function generateID(id) {

    let pattern = {
        1: "0000",
        2: "000",
        3: "00",
        4: "0",
    };
    var length = Math.ceil(Math.log(id + 1) / Math.LN10);
    return pattern[length] + id;
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}