$(document).ready(function () {

    var table = $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "supplier" },
            { "data": "department" },
            // { "data": "type" },
            { "data": "date" },
            { "data": "remark" },
            { "data": "status", className: "status" },
            { "data": "view", className: "view" },
        ],
        columnDefs: [
            { width: 100, targets: 0 },
            { width: 100, targets: 1 },
            { width: 100, targets: 2 },
            { width: 100, targets: 3 },
            { width: 100, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
        ],
    });
    //table.column(8).visible(false);
    allMaterialRequisitionPending('any', 'any');
    loadDepartments();

    $('#cmbDepartment').on('change', function () {
        allMaterialRequisitionPending($(this).val(), $('#cmbApproved').val());
    });

    $('#cmbApproved').on('change', function () {
        allMaterialRequisitionPending($('#cmbDepartment').val(), $(this).val());
    });

});


function allMaterialRequisitionPending(department, status) {
    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionPendingListController/allMaterialRequisitionPending/" + department + "/" + status,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {},
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var reference_no = response.data.result[i]['external_id'];
                    var name = response.data.result[i]['employee_name'];
                    var department = response.data.result[i]['department'];
                    // var type = response.data.result[i]['type'];
                    var designation = response.data.result[i]['trans_date'];
                    var remark = response.data.result[i]['remarks'];
                    // var status = response.data.result[i]['status'];
                    var req_status = response.data.result[i]['req_status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    
                    // var disabled = "";
                    // if (status == 1) {
                    //     approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                    //     disabled = "disabled";
                    // } else if (status == 2) {
                    //     approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                    //     disabled = "disabled";
                    // }

                    var status_icon = '';
                    if (req_status == 'pending') {
                        status_icon = 'Pending <i class="fa fa-hourglass-half text-success" aria-hidden="true"></i>';
                    } else {
                        status_icon = 'Partial <i class="fa fa-pie-chart text-primary" aria-hidden="true"></i>';
                    }


                    data.push({
                        "reference_no": reference_no,
                        "supplier": name,
                        "department": department,
                        // "type": type,
                        "date": designation,
                        "remark": remark,
                        "status": status_icon,
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);
        },
        complete: function () {}
    });
}


function edit(id) {
    location.href = "/sc/materialRequisition?id=" + id + "&action=edit";
}


function view(id) {
    location.href = "/sc/materialRequisitionView?id=" + id + "&action=view";
}


function loadDepartments() {


    $.ajax({
        type: "GET",
        url: "/sc/materialRequisitionListController/loadDepartments",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //$('.btn').prop("disabled", true);
            //document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;
            $('#cmbDepartment').empty();
            $('#cmbDepartment').append('<option value="any">Any</option>');

            $.each(result, function (index, value) {
                $('#cmbDepartment').append('<option value="' + value['department_id'] + '">' + value['department'] + '</option>');
            });
        },
        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });




}


/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}