$(document).ready(function () {

    var table = $('#myTable').DataTable({
        "scrollX": true,
        "order": [],
        "columns": [
            { "data": "reference_no" },
            { "data": "external_no" },
            { "data": "supplier" },
            { "data": "date" },
            { "data": "view", className: "view" },
            { "data": "print", className: "print" },
            { "data": "approve", className: "approve" },
            { "data": "delete", className: "delete" },
        ],
        columnDefs: [
            { width: 200, targets: 0 },
            { width: 200, targets: 2 },
            { width: 30, targets: 3 },
            { width: 30, targets: 4 },
            { width: 30, targets: 5 },
            { width: 30, targets: 6 },
            { width: 30, targets: 7 },
        ],
    });
    table.column(6).visible(false);
    allMaterialReturn();

});


function allMaterialReturn() {
    $.ajax({
        type: "GET",
        url: "/sc/materialReturnBagsListController/allMaterialReturn",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            if (response.data.success) {
                var data = [];

                for (i = 0; i < response.data.result.length; i++) {
                    var id = response.data.result[i]['internal_id'];
                    var external_no = response.data.result[i]['external_id'];
                    var reference_no = response.data.result[i]['ref_external_id'];
                    var name = response.data.result[i]['employee_name'];
                    var designation = response.data.result[i]['trans_date'];
                    var status = response.data.result[i]['status'];
                    var string_id = "'" + id + "'";

                    var approve_icon = '';
                    if (status == 1) {
                        approve_icon = '<i class="fa fa-check-circle-o fa-3x text-success" aria-hidden="true"></i>';
                    } else if (status == 2) {
                        approve_icon = '<i class="fa fa-times-circle-o fa-3x text-danger" aria-hidden="true"></i>';
                    }


                    data.push({
                        "reference_no": reference_no,
                        "external_no": external_no,
                        "supplier": name,
                        "date": designation,
                        "view": '<button class="btn btn-success" onclick="view(' + string_id + ')"><i class="fa fa-eye" aria-hidden="true"></i></button>',
                        "print": '<button class="btn btn-success" onclick="print(' + string_id + ')"><i class="fa fa-print" aria-hidden="true"></i></button>',
                        "approve": approve_icon,
                        "delete": '<button class="btn btn-danger" onclick="_delete(' + string_id + ')"><i class="fa fa-trash" aria-hidden="true"></i></button>'
                    });
                }

                var table = $('#myTable').DataTable();
                table.clear();
                table.rows.add(data).draw();
            }
        },

        error: function (error) {
            console.log(error);


        },
        complete: function () {

        }

    });
}



function view(id) {
    location.href = "/sc/material_return_bags?id=" + id + "&action=view";
}





function print(id) {

    $.ajax({
        type: "GET",
        url: "/sc/materialReturnBagsListController/materialReturnReport/" + id,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {
            //$('.btn').prop("disabled", true);
            //document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
        },
        success: function (response) {
            console.log(response);
            var result = response.data.result;
            console.log(result);
            materialReturnPrint(result, 'PRINT');

        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {
            //$('#btnPrint').text('Print');
            //$('.btn').prop("disabled", false);
        }

    });

}


function materialReturnPrint(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];

    var header_data = result.header;


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: Page.getReportName(), fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Material Return Bags', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{
                                table: {
                                    widths: ['*', 150],
                                    headerRows: 1,
                                    body: [
                                        [{ text: 'Supervisor : ' + header_data.supervisor, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Referance No : ' + header_data.referance_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Date : ' + header_data.date, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Store : ' + header_data.store, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Department : ' + header_data.department, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Type : ' + header_data.type, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Manufacturing Order No : ' + header_data.manufacturing_order_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],
                                        [{ text: '', fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }, { text: 'Machine No. : ' + header_data.machine_no, fontSize: 9, bold: false, alignment: 'left', border: [false, false, false, false] }],

                                    ],

                                }, border: [false, false, false, false]
                            }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var footer_data = result.header;
    var Body = [
        {
            table: {
                widths: [50, '*', 50, 50, '*'],
                headerRows: 1,
                body: materialReturnPrintBody(result.body),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },


        },
        { canvas: [{ type: 'line', x1: 0, y1: 0, x2: 515, y2: 0, lineWidth: 1 }] },

    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function materialReturnPrintBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Product ID', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Product Name', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Unit', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] },
    { text: 'Qty', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
    { text: 'Comments', fontSize: font_size, bold: true, alignment: 'center', border: [true, true, true, true] }]);

    var data = result.data;
    for (i = 0; i < data.length; i++) {
        body.push([
            { text: data[i].product_id, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: data[i].product, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: data[i].unit, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },
            { text: parseFloat(data[i].quantity).toFixed(2), fontSize: font_size, alignment: 'right', border: [false, false, false, false] },
            { text: data[i].comments, fontSize: font_size, alignment: 'center', border: [false, false, false, false] },


        ]);
    }

    return body;
}

