
var setting_array = {
    "site": null,
    "stores": null,
    "producttype": null,
    "grouplevel1": null,
    "grouplevel2": null,
    "grouplevel3": null,
    "without0": null,
    "productname": null,
};

var REPORT_ID = 0;

$(document).ready(function () {
    allSettings();
    $('#selcStores').prop("disabled", true);
    $('#txtProductName').prop("disabled", true);
    $('#selcProductType').prop("disabled", true);
    $('#selcProductGroupLevel1').prop("disabled", true);
    $('#selcProductGroupLevel2').prop("disabled", true);


    $('input[name="startDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    $('input[name="startDate"]').on('apply.daterangepicker', function (ev, picker) {
        setDateRangeToDatePickerLast('endDate', picker.startDate.format('YYYY MM D'));
        

    });

    $('input[name="endDate"]').daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        locale: {
            format: 'YYYY-MM-DD',
        }

    });
    setDateRangeToDatePickerLast('endDate', $('input[name="startDate"]').val());




    $('#checkStoresSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcStores').prop("disabled", false);
            setting_array.stores = $('#selcStores').val();
        } else {
            $('#selcStores').prop("disabled", true);
            setting_array.stores = null;
        }
        //switch_settings('checkDepartmentSearch');
    });

    $('#checkProductTypeSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductType').prop("disabled", false);
            var value = $('#selcSection').val();
            setting_array.producttype = $('#selcProductType').val();
            // allSubsection(value);
        } else {
            $('#selcProductType').prop("disabled", true);
            setting_array.producttype = null;
        }
        //switch_settings('checkSectionSearch');
    });

    $('#checkProductSearch').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#txtProductName').prop("disabled", false);
            setting_array.productname = $('#txtProductName').val();
            $('#checkProductGroupLevel1Search').prop('checked',false);
            $('#checkProductGroupLevel2Search').prop('checked',false);
            $('#checkProductGroupLevel1Search').trigger('change');
            $('#checkProductGroupLevel2Search').trigger('change');
        } else {
            $('#txtProductName').prop("disabled", true);
            setting_array.productname = null;
        }
        //switch_settings('checkDepartmentSearch');
    });

    $('#checkProductGroupLevel1Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel1').prop("disabled", false);
            setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
            $('#checkProductSearch').prop('checked',false);
            $('#checkProductSearch').trigger('change');
            $('#txtProductName').val('');
        } else {
            $('#selcProductGroupLevel1').prop("disabled", true);
            setting_array.grouplevel1 = null;
        }
        //switch_settings('checkCompanySearch');
    });


    $('#checkProductGroupLevel2Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel2').prop("disabled", false);
            setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
            $('#checkProductSearch').prop('checked',false);
            $('#checkProductSearch').trigger('change');
            $('#txtProductName').val('');
        } else {
            $('#selcProductGroupLevel2').prop("disabled", true);
            setting_array.grouplevel2 = null;
        }
        //switch_settings('checkTeamSearch');

    });

    $('#checkProductGroupLevel3Search').change(function () {
        var bool = $(this).is(":checked");
        if (bool) {
            $('#selcProductGroupLevel3').prop("disabled", false);
            setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
        } else {
            $('#selcProductGroupLevel3').prop("disabled", true);
            setting_array.grouplevel3 = null;
        }
        //switch_settings('checkTeamSearch');

    });



    $('#selcStores').change(function () {
        setting_array.stores = $('#selcStores').val();
    });

    $('#selcProductType').change(function () {
        setting_array.producttype = $('#selcProductType').val();
    });

    $('#txtProductName').change(function () {
        setting_array.productname = $('#txtProductName').optionID();
    });

    $('#selcProductGroupLevel1').change(function () {
        setting_array.grouplevel1 = $('#selcProductGroupLevel1').val();
    });

    $('#selcProductGroupLevel2').change(function () {
        setting_array.grouplevel2 = $('#selcProductGroupLevel2').val();
    });

    $('#selcProductGroupLevel3').change(function () {
        setting_array.grouplevel3 = $('#selcProductGroupLevel3').val();
    });

    $('#cmbReport').change(function () {
        REPORT_ID = $(this).val();
        $('#lblEmployee').text('Employee');
        if (REPORT_ID == 1) {
            showDate('DATE_RANGE');
        } else {
            showDate('DATE_RANGE');
        }
    });

    $('#selcProductGroupLevel1').on('change', function () {
        $('#selcProductGroupLevel2').prop("disabled", true);
        $('#selcProductGroupLevel3').prop("disabled", true);
        $('#checkProductGroupLevel2Search').prop('checked',false);
        $('#checkProductGroupLevel3Search').prop('checked',false);
        category_level2($(this).val());
    });

    $('#selcProductGroupLevel2').on('change', function () {
        $('#selcProductGroupLevel3').prop("disabled", true);
        $('#checkProductGroupLevel3Search').prop('checked',false);
        category_level3($(this).val());
    });

});





function allSettings() {

    $.ajax({
        type: "GET",
        url: "/sc/producrtHistoryReport/allSettings",
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            if (response.data.success) {
                var settings = response.data.result.settings;
                appendOptionCombo("selcStores", settings.stores);
                appendOptionCombo("selcProductType", settings.producttype);
                appendOptionCombo("selcProductGroupLevel1", settings.grouplevel1);
                $('#selcProductGroupLevel1').trigger('change');
                //appendOptionCombo("selcProductGroupLevel2", settings.grouplevel2);
                $('#txtProductName').setData(settings.productname);

            } else {
                showErrorMessage();
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function category_level2(category_level1) {

    $.ajax({
        type: "GET",
        url: "/sc/stockReport/category_level2/"+category_level1,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            $('#selcProductGroupLevel2').empty();
            $('#selcProductGroupLevel2').append('<option value="disabled" disabled selected>Select here</option>');
            for (var i = 0; i < response.length; i++) {
                $('#selcProductGroupLevel2').append('<option value="' + response[i].group_level_2_id + '">' + response[i].group_level_2 + '</option>')
            }
            $('#selcProductGroupLevel2').trigger('change');
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}



function category_level3(category_level2) {

    $.ajax({
        type: "GET",
        url: "/sc/stockReport/category_level3/"+category_level2,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 800000,
        beforeSend: function () {

        },
        success: function (response) {
            console.log(response);

            $('#selcProductGroupLevel3').empty();
            $('#selcProductGroupLevel3').append('<option value="disabled" disabled selected>Select here</option>');
            for (var i = 0; i < response.length; i++) {
                $('#selcProductGroupLevel3').append('<option value="' + response[i].group_level_3_id + '">' + response[i].group_level_3 + '</option>')
            }
        },
        error: function (error) {
            console.log(error);
            showErrorMessage();

        },
        complete: function () {

        }

    });
}





function appendOptionCombo(combobox, result) {

    $('#' + combobox).empty();
    $('#' + combobox).append('<option value="disabled" disabled selected>Select here</option>');
    for (i = 0; i < result.length; i++) {
        $('#' + combobox).append('<option value="' + result[i].id + '">' + result[i].value + '</option>');
    }
}








function settings() {

    return "site=" + setting_array.site + "&"
        + "stores=" + setting_array.stores + "&"
        + "producttype=" + setting_array.producttype + "&"
        + "grouplevel1=" + setting_array.grouplevel1 + "&"
        + "grouplevel2=" + setting_array.grouplevel2 + "&"
        + "grouplevel3=" + setting_array.grouplevel3 + "&"
        + "without0=" + setting_array.without0 + "&"
        + "productname=" + setting_array.productname;
}


function createReport(flag) {

    if ($('#txtProductName').val() == "" && $('#checkProductSearch').is(":checked")) {
        showWarningMessage("Please select Product");
        return;
    }



    if (REPORT_ID == 0) {
        showWarningMessage("Please select Report title");
        return;
    }


    /*if ($('#txtProductName').val() == "") {
        showWarningMessage("Please select Product.");
        return;
    }*/



    if (REPORT_ID == 1) {

        console.log("/sc/producrtHistoryReport/productHistoryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val());
        $.ajax({
            type: "GET",
            url: "/sc/producrtHistoryReport/productHistoryReport/" + JSON.stringify(setting_array) + "/" + $('#txtDateFrom').val() + "/" + $('#txtDateTo').val(),
            processData: false,
            contentType: false,
            cache: false,
            timeout: 800000,
            beforeSend: function () {
                $('.btn').prop("disabled", true);
                document.getElementById('btnPrint').innerHTML = '<i class="fa fa-circle-o-notch fa-spin"></i>';
            },
            success: function (response) {
                console.log(response);
                var result = response.data.result;
                console.log(result);
                productHistoryReport(result, flag);

            },
            error: function (error) {
                console.log(error);
                showErrorMessage();

            },
            complete: function () {
                $('#btnPrint').text('Print');
                $('.btn').prop("disabled", false);
            }

        });

    }



}




function productHistoryReport(result, flag) {

    var headerFontSize = 8;
    var Title = [
        { text: '' }
    ];


    var Header = [
        {
            content: [

                {
                    table: {
                        widths: ['*'],
                        headerRows: 1,
                        body: [
                            [{ text: 'Riococo  Lanka (Pvt) Ltd', fontSize: 16, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            //[{ text: '\n', fontSize: 8, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Product History Report', fontSize: 14, bold: true, alignment: 'center', border: [false, false, false, false] }],
                            [{ text: 'Filterd by :' + getFilterString(), fontSize: 8, bold: true, alignment: 'left', border: [false, false, false, false] }],
                            [{ text: result['report_date'] + '  -  Opening Balance : ' + parseFloat(result['opening_balance']).toFixed(2), fontSize: 8, bold: true, alignment: 'right', border: [false, false, false, false] }],
                        ],

                    },
                    margin: [0, 0],
                },

            ]
        }
    ];



    var Body = [
        {
            table: {
                widths: [50, 60, '*', 70, 50, '*'],
                headerRows: 1,
                body: productHistoryReportBody(result.body),
                //body:[{text:""},{text:""},{text:""},{text:""}],

            },

        },
    ];




    var Footer = [
        {
            color: 'red',
            fontSize: 8,
            alignment: 'center',
            margin: [0, 0]
        }
    ];






    var page = new Page();
    page.setPageSize('A4');
    page.setPageOrientation('portrait');
    page.setPageMargin([10, 10, 10, 10]);
    page.setTitle(Title);
    page.setHeader(Header, Page.EVERY);
    page.setBody(Body);
    page.setFooter(Footer);
    if (flag == 'EXPORT') {
        page.export();
    } else if (flag == 'PRINT') {
        page.preview();
    }
}


function productHistoryReportBody(result) {
    var font_size = 8;
    var body = [];
    body.push([{ text: 'Date', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
        { text: 'Transaction No', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
        { text: 'Product', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
        { text: 'Description', fontSize: font_size, bold: true, alignment: 'left', border: [true, true, true, true] },
        { text: 'Quantity', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] },
        { text: 'Balance', fontSize: font_size, bold: true, alignment: 'right', border: [true, true, true, true] }
    ]);
    for (i = 0; i < result.length; i++) {
        body.push([
            { text: result[i].date, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].external_id, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].product_name, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].description, fontSize: font_size, alignment: 'left', border: [false, false, false, true] },
            { text: result[i].quantity, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
            { text: result[i].balance, fontSize: font_size, alignment: 'right', border: [false, false, false, true] },
        ]);
    }
    return body;
}






function showDate(args) {

    if (args == 'SINGLE_DATE') {
        $('#endDate').hide();
    } else {
        $('#endDate').show();
    }
}



function _export() {
    createReport('EXPORT');
}



/**
* showSuccessMessage
* This function is used to show success message.
* @param message This is the paramter to require message content
*/
function showSuccessMessage(message) {
    toastr.success(message);
}


/**
* showWarningMessage
* This function is used to show warning message.
* @param message This is the paramter to require message content
*/
function showWarningMessage(message) {
    toastr.warning(message);
}



/**
* showErrorMessage
* This function is used to show error message.
* @param message This is the paramter to require message content
*/
function showErrorMessage() {
    toastr.error('Something went wrong');
}


function getFilterString() {
    var filters = "";
    if ($('#checkSiteSearch').is(":checked")) {
        filters += " Site: " + $("#selcSite option:selected").text() + ", ";
    }
    if ($('#checkStoresSearch').is(":checked")) {
        filters += " Stores: " + $("#selcStores option:selected").text() + ", ";
    }
    if ($('#checkProductTypeSearch').is(":checked")) {
        filters += " ProductType: " + $("#selcProductType option:selected").text() + ", ";
    }
    if ($('#checkProductGroupLevel1Search').is(":checked")) {
        filters += " GroupLevel1: " + $("#selcProductGroupLevel1 option:selected").text() + ", ";
    }
    if ($('#checkProductGroupLevel2Search').is(":checked")) {
        filters += " GroupLevel2: " + $("#selcProductGroupLevel2 option:selected").text() + ", ";
    }
    /*if ($('#checkProductGroupLevel3Search').is(":checked")) {
        filters += " GroupLevel3: " + $("#selcProductGroupLevel3 option:selected").text() + ", ";
    }
    if ($('#checkWithout0').is(":checked")) {
        filters += " Without0: " + $("#selcWithout0 option:selected").text() + ", ";
    }
    if ($('#checkProductName').is(":checked")) {
        filters += " ProductName: " + $("#selcProductName option:selected").text() + ", ";
    }*/
    return filters;
}