@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">

@endsection

@section('content')

<div class="page-header">
    <div>
        <h3> Bags Cutting Return </h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <div class="col-md-10">
                                <h6>Bags Cutting Return</h6>
                            </div>
                            <div class="col-md-2" style="text-align: right;">
                                <button type="button" class="btn btn-primary" id="btnRetrieveDispatch">Retrieve
                                    Dispatch</button>
                            </div>
                        </div>
                        {{-- <div class="row border-bottom bg-light" style="padding: 10px;">
                            <h6>Bags Cutting Return </h6>
                        </div> --}}


                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 100px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" autocomplete="off"
                                        id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">
                                            Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate"
                                        name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">
                                            Cutting Center</div>
                                    </div>
                                    <select id="cmbCuttingCenter" name="cutting_center_id"
                                        class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                        </div>

                        {{-- <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Received By</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtReceivedBy" name="received_by" style="min-width: 100%;">!-->
                                    <input type="text" class="form-control form-control-sm" id="txtReceivedBy">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Store</div>
                                    </div>
                                    <select id="cmbStores" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Supplier's Ref.No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSupplierRefNo" name="supplier_ref_no">
                                </div>
                            </div>

                        </div> --}}


                        {{-- <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Po No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtPurchase_order_no" name="purchase_order_no">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2 flex-nowrap">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm select2" style="width: 100px;">Manufacturing Order</div>
                                    </div>
                                    <select class="form-control form-control-sm" id="cmbManufacturingOrder" name="cmbManufacturingOrder"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Transaport By</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtTransport_by" name="transport_by">
                                </div>
                            </div>

                        </div> --}}

                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 100px;">Transaport By</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtTransport_by"
                                        name="transport_by">
                                </div>
                            </div>
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 100px;">Vehicle No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtVehicle_no"
                                        name="vehicle_no">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">
                                            Store</div>
                                    </div>
                                    <select id="cmbStores" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2 flex-nowrap">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 100px;">Po No</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm" id="txtPurchase_order_no" name="purchase_order_no">!-->
                                    <select class="form-control form-control-sm" id="cmbPoNo" name="poNo"></select>
                                </div>
                            </div>
                        </div>


                        <div class="row mt-3">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Company Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtCompanyDamage"
                                        name="company_damage" readonly>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Cutting Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtCuttingDamage"
                                        name="cutting_damage">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Total Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtTotalDamage"
                                        name="total_damage" readonly>
                                </div>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Printing Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtPrintingDamage"
                                        name="printing_damage">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Gazzet Isses</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGazzetIsses"
                                        name="gazzet_isses">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Seal Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSealDamage"
                                        name="seal_damage">
                                </div>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm"
                                            style="width: 150px;">Other Damage</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtOtherDamage"
                                        name="other_damage">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mt-1 mb-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Remarks</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtRemarks" name="remarks">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblData"></table>
                                </div>
                            </div>
                        </div>

                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm"
                                            id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm"
                                            id="btnReject">Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>


    <div id="productChooser"></div>
    <div id="supplierChooser"></div>
    <div id="grnChooser"></div>

    <!--Modal-->
    <div class="modal fade" id="mrDataModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mrDataModalTitle">Retrieve MR</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="mrDataModalBody">
                    <div class="row">

                        <div class="col-md-12">
                            <h6>Material Request</h6>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblMr" class="table table-bordered dataTable dtr-inline collapsed"
                                            role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th hidden>ID</th>
                                                    <th style="max-width: 100px;">Date</th>
                                                    <th style="max-width: 100px;">Reference No</th>
                                                    <th>Stores</th>
                                                    <th>Center</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBodyMrHeader"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblHeaderMrData" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th style="max-width: 100px;">Product ID</th>
                                                    <th>Name</th>
                                                    <th style="max-width: 100px;">Quantity</th>
                                                    <th style="max-width: 100px;">Unit</th>
                                                    <th style="max-width: 80px;">Reject</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBopdyMrData"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="text-align: left;">
                                    <button type="button" class="btn btn-primary" id="btnGetDataMR">Get Data</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnMrDataSave" class="btn btn-primary" hidden>Save</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <script src="{{ url('vendors/selects/select2.min.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>">
    </script>
    <!-- Datachooser -->


    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/available_qty_before.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/bags_cutting_return.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/bags_cutting_return_retrieve.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection
