@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">
<!-- Datachooser -->
{{-- <link rel="stylesheet" href="{{ url('assets/js/dataChooser/dataChooser.min.css') }}" type="text/css"> --}}
<link rel="stylesheet" href="{{ Module::asset('sc:js/dataChooser/dataChooser.min.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
{{-- <link rel="stylesheet" href="{{ url('assets/js/autocomplete/css/autocomplete.min.css') }}" type="text/css"> --}}
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">

<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Good Received M.R</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">
                <form id="formMR">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Refferance No.</label>
                            <input type="text" class="form-control" id="txtRefferance" autocomplete="off" disabled>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Date</label>
                            <input type="text" class="form-control" id="dateMR" name="date" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Site</label>
                            <select class="form-control" id="cmbSite"></select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Supplier Type</label>
                            <select class="form-control" id="cmbSupplierType">
                                <option value="">Select Supplier Type</option>
                                <option value="1">Supplier</option>
                                <option value="2">Material Plant</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Supplier</label>
                            <input type="text" class="form-control" id="txtSupplier" autocomplete="off" readonly>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Material Plant</label>
                            <select class="form-control" id="cmbPlant" disabled></select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Supplier's Ref.No</label>
                            <input type="text" class="form-control" id="txtSupplierReffNo" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Store</label>
                            <select class="form-control" id="cmbStores"></select>
                        </div>
                    </div>
                    <div class="row">
                        {{-- <div class="col-md-3 mb-3">
                            <label>PO No.</label>
                            <select id="cmbPO" name="cmbPO" class="form-control form-control-sm select2"></select>
                        </div> --}}
                        <div class="col-md-3 mb-3">
                            <label>Vehicle No</label>
                            <input type="text" class="form-control" id="txtVehicleNO" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Number of bags</label>
                            <input type="text" class="form-control" id="txtNoOfEmptyBags" autocomplete="off">
                        </div>
                        
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Driver Name</label>
                            <input type="text" class="form-control" id="txtDriver" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Weigh Bill No</label>
                            <input type="text" class="form-control" id="txtWeighBillNo" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Item</label>
                            <input type="text" class="form-control" id="txtItem" autocomplete="off">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>First Weight</label>
                            <input type="text" class="form-control float" id="txtFirstWeight" autocomplete="off" oninput="computeNetWeight()">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>First Weight Time</label>
                            <input type="text" class="form-control" id="txtFirstWeightTime" name="firstWeightTime" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Second Weight</label>
                            <input type="text" class="form-control float" id="txtSecondWeight" autocomplete="off" oninput="computeNetWeight()">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Second Weight Time</label>
                            <input type="text" class="form-control" id="txtSecondWeightTime" name="secondWeightTime" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Net Weight</label>
                            <input type="text" class="form-control" id="txtNetWeight" autocomplete="off" disabled>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Received By</label>
                            <input type="text" class="form-control" id="txtReceivedBy" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Wastage(%)</label>
                            <input type="text" class="form-control" id="txtWastage" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Moisture(%)</label>
                            <input type="text" class="form-control" id="txtMoisture" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Sand(%)</label>
                            <input type="text" class="form-control" id="txtSand" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>EC level</label>
                            <input type="text" class="form-control" id="txtEClevel" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Volume</label>
                            <input type="text" class="form-control" id="txtVolume" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label>Finders</label>
                            <input type="text" class="form-control" id="txtFinders" autocomplete="off">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Comments</label>
                            <textarea class="form-control" id="txtComment"></textarea autocomplete="off">
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3" style="text-align: right;">
                            <button type="button" class="btn btn-primary" id="btnAction">Save</button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnReject" hidden>Reject</i></button>
                                    </div>
                                </div>


        </div>
    </div>
</div>


    <div id="supplierChooser"></div>
    <div id="productChooser"></div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- DataTable -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ url('vendors/selects/select2.min.js') }}"></script>

    <!-- Datachooser -->
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplts/js/autocomplete/js/autocomplete.min.js') }}"></script> --}}
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}"></script>ete -->
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/numeric.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_received_mr.js') }}?random=<?php echo uniqid(); ?>"></script>




    @endsection