@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">

<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">
<style>
    .selected {
        color: white;
        background-color: #0275d8;
    }
</style>

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Goods Transfer Bags</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <div class="col-md-10">
                                <h6 style="padding-top: 10px;">Goods Transfer Bags</h6>
                            </div>
                            <div class="col-md-2" style="text-align: right;">
                                <button type="button" class="btn btn-primary" id="btnRetrieveMR">Retrieve MR Bags</button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate" name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2 flex-nowrap">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm select2" style="width: 100px;">Manufacturing Order</div>
                                    </div>
                                    <select class="form-control form-control-sm" id="cmbManufacturingOrder" name="cmbManufacturingOrder"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">

                            </div>


                        </div>



                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Store From</div>
                                    </div>
                                    <select id="cmbStoresFrom" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Store To</div>
                                    </div>
                                    <select id="cmbStoresTo" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>


                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblData"></table>
                                </div>
                            </div>
                        </div>


                        <hr>


                        <div class="row">
                            <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <button type="button" id="btnAttachment" class="btn btn-primary">Attachment</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table id="tblGRNAttachment" class="table table-striped  datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="thTitle">Title</th>
                                                        <th class="thView">View</th>
                                                        <th class="thDownload">Down</th>
                                                        <th class="thDelete">Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnReject">Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>


    <div id="productChooser"></div>
    <div id="supplierChooser"></div>


    <!--Attachment-->
    <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="attachmentAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('/GoodsTransferBagsController/uploadAttachment')}}" class="dropzone" method="POST" id="myDropzone" name="myDropzone">
                                @csrf
                                <input type="hidden" id="order_id" name="order_id" value="">
                                <input type="hidden" id="attachmnet_token" name="attachmnet_token" value="">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--Modal-->
    <div class="modal fade" id="mrDataModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mrDataModalTitle">Retrieve MR Bags</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="mrDataModalBody">
                    <div class="row">

                        <div class="col-md-12">
                            <h6>Material Request</h6>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblMr" class="table table-bordered dataTable dtr-inline collapsed" role="grid" aria-describedby="example1_info">
                                            <thead>
                                                <tr>
                                                    <th hidden>ID</th>
                                                    <th style="max-width: 100px;">Date</th>
                                                    <th style="max-width: 100px;">Refferance No</th>
                                                    <th>Store</th>
                                                    <th>Department</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBodyMrHeader"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblHeaderMrData" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th style="max-width: 100px;">Product ID</th>
                                                    <th>Name</th>
                                                    <th style="max-width: 100px;">Quantity</th>
                                                    <th style="max-width: 100px;">Unit</th>
                                                    <th style="max-width: 80px;">Reject</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBopdyMrData"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="text-align: left;">
                                    <button type="button" class="btn btn-primary" id="btnGetDataMR">Get Data</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnMrDataSave" class="btn btn-primary" hidden>Save</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <script src="{{ url('vendors/selects/select2.min.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datachooser -->
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>

    <script src="{{ Module::asset('sc:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_transfer_bags.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/available_qty_before_bags.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_transfer_bags_retrieve.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection