@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/selects/select2.min.css') }}" type="text/css">


<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">
<link rel="stylesheet" href="{{ url('vendors/dropzone/dropzone.css') }}" type="text/css">
<style>
    .selected {
        color: white;
        background-color: #0275d8;
    }
</style>

<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Goods Transfer M.R</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <div class="col-md-10">
                                <h6 style="padding-top: 10px;">Goods Transfer M.R</h6>
                            </div>
                            <div class="col-md-2" style="text-align: right;">
                                <button type="button" class="btn btn-primary" id="btnRetrieveMR">Retrieve MR</button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate" name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                {{-- <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group flex-nowrap">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">PO No</div>
                                    </div>
                                    <select id="cmbPO" name="cmbPO" class="form-control form-control-sm select2"></select>
                                    </div>
                                </div> --}}
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group flex-nowrap">
                                        <div class="input-group-prepend">
                                            <div class="input-group-text form-control form-control-sm" style="width: 150px;">Manufacturing Order</div>
                                        </div>
                                        <select id="cmbManufacturingOrder" name="manufacturingOrder" class="form-control form-control-sm select2"></select>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Store From</div>
                                    </div>
                                    <select id="cmbStoresFrom" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Store To</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="cmbStoresTo" name="cmbStoresTo">
                                    {{-- <select id="cmbStoresTo" name="cmbStoresTo" class="form-control form-control-sm"></select> --}}
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Vehicle No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtVehicleNO" name="txtVehicleNO">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Driver Name</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtDriver" name="txtDriver">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Number of bags</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtNoOfBags" name="txtNoOfBags">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Weigh Bill No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtWeighBillNo" name="txtWeighBillNo">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Wastage(%)</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtWastage" name="txtWastage">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Moisture(%)</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtMoisture" name="txtMoisture">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Sand(%)</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSand" name="txtSand">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">EC level</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtEClevel" name="txtEClevel">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Volume</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtVolume" name="txtVolume">
                                </div>
                            </div>

                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Finders</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtFinders" name="txtFinders">
                                </div>
                            </div>
                        </div>








                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-sm table-striped" id="tblData"></table>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">First Weight</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm float" id="txtFirstWeight" autocomplete="off" oninput="computeNetWeight()">
                                </div>
                            </div>
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 145px;">First Weight Time</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtFirstWeightTime" name="firstWeightTime" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">Second Weight</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm float" id="txtSecondWeight" autocomplete="off" oninput="computeNetWeight()">
                                </div>
                            </div>
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 145px;">Second Weight Time</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSecondWeightTime" name="secondWeightTime" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-2">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">Net Weight</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm float" id="txtNetWeight" autocomplete="off" disabled>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-8 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;height: 100%;">Remark</div>
                                    </div>
                                    <textarea class="form-control form-control-sm float" id="txtComment" autocomplete="off"></textarea>
                                </div>
                            </div>
                        </div>




                        <hr>


                        <div class="row">
                            <div class="col-md-12 mt-2">
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <button type="button" id="btnAttachment" class="btn btn-primary">Attachment</button>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12 mb-3">
                                        <div class="table-responsive">
                                            <!-- Required for Responsive -->
                                            <table id="tblGRNAttachment" class="table table-striped  datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="thTitle">Title</th>
                                                        <th class="thView">View</th>
                                                        <th class="thDownload">Down</th>
                                                        <th class="thDelete">Delete</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnReject">Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>


    <div id="productChooser"></div>
    <div id="supplierChooser"></div>


    <!--Attachment-->
    <div class="modal fade" id="attachmentAddModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="attachmentAddModalTitle">Add attachment here</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="attachmentAddModalBody">
                    <div class="row">
                        <div class="col-md-12">
                            <form action="{{route('/GoodsTransferMRController/uploadAttachment')}}" class="dropzone" method="POST" id="myDropzone" name="myDropzone">
                                @csrf
                                <input type="hidden" id="order_id" name="order_id" value="">
                                <input type="hidden" id="attachmnet_token" name="attachmnet_token" value="">
                                <div class="fallback">
                                    <input name="file" type="file" multiple />
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close
                        </button>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--Modal-->
    <div class="modal fade" id="mrDataModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mrDataModalTitle">Retrieve MR</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <i class="ti-close"></i>
                    </button>
                </div>
                <div class="modal-body" id="mrDataModalBody">
                    <div class="row">

                        <div class="col-md-12">
                            <h6>Material Request</h6>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblMrHeader" class="table">
                                            <thead>
                                                <tr>
                                                    <th hidden>ID</th>
                                                    <th style="max-width: 100px;">Date</th>
                                                    <th style="max-width: 100px;">Refferance No</th>
                                                    <th>Store</th>
                                                    <th>Department</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBodyMrHeader"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="table-responsive">
                                        <!-- Required for Responsive -->
                                        <table id="tblHeaderMrData" class="table table-striped">
                                            <thead>
                                                <tr>
                                                    <th style="max-width: 100px;">Product ID</th>
                                                    <th>Name</th>
                                                    <th style="max-width: 100px;">Quantity</th>
                                                    <th style="max-width: 100px;">Unit</th>
                                                    <th style="max-width: 100px;">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="tblBopdyMrData"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12" style="text-align: left;">
                                    <button type="button" class="btn btn-primary" id="btnGetDataMR">Get Data</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" id="btnMrDataSave" class="btn btn-primary" hidden>Save</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datachooser -->
    <script src="{{ url('vendors/dropzone/dropzone.js') }}"></script>
    <script src="{{ url('vendors/selects/select2.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/progress_widget.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table_goods_transfer_mr.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_transfer_mr.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/available_qty_before.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/goods_transfer_mr_retrieve.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection