@extends('sc::layouts.app')

@section('head')
<!-- Prism -->
<link rel="stylesheet" href="{{ url('vendors/prism/prism.css') }}" type="text/css">


<!-- Datepicker -->
<link rel="stylesheet" href="{{ url('vendors/datepicker/daterangepicker.css') }}" type="text/css">
<!-- AutoComplete -->
<link rel="stylesheet" href="{{ Module::asset('sc:js/autocomplete/css/autocomplete.min.css') }}" type="text/css">
<!-- DataTable -->
<link rel="stylesheet" href="{{ url('vendors/dataTable/datatables.min.css') }}" type="text/css">


<meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')

<div class="page-header">
    <div>
        <h3>Raw Material Requisition</h3>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">
                    <a href="#">Home</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Pages</a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Form Page</li>
            </ol>
        </nav>
    </div>
</div>

<div class="row">
    <div class="col-md-12">

        <div class="card">
            <div class="card-body">

                <div class="row">
                    <div class="col-md-11 border">
                        <div class="row border-bottom bg-light" style="padding: 10px;">
                            <div class="col-md-10">
                                <h6 style="padding-top: 10px;">Raw Material Requisition</h6>
                            </div>
                            <div class="col-md-2" style="text-align: right;">
                                <button type="button" class="btn btn-primary" id="btnRetrieveMR">BOM</button>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Reference No.</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtExternal_id" name="external_id" disabled>
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">Date</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtGrnDate" name="trans_date">
                                </div>
                            </div>

                            <div class="col-md-4 mt-3">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Department</div>
                                    </div>
                                    <select id="cmbDepartment" class="form-control form-control-sm"></select>
                                </div>
                            </div>

                        </div>



                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2" style="padding: 0px;">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Supervisor</div>
                                    </div>
                                    <!--<input type="text" class="form-control form-control-sm auto-complete" autocomplete="off" id="txtSupervisor" name="received_by" style="min-width: 100%;">!-->
                                    <input type="text" class="form-control form-control-sm" id="txtSupervisor">
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 90px;">From Store</div>
                                    </div>
                                    <select id="cmbStores" name="store_id" class="form-control form-control-sm">
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 120px;">Type</div>
                                    </div>
                                    <select id="cmbMiType" name="miType" class="form-control form-control-sm">
                                        <option value="0">General</option>
                                        <option value="1">Production</option>
                                        <option value="2">Project</option>
                                        <option value="3">Transport</option>
                                    </select>
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            {{-- <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 150px;">Vehicle No</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtVehicleNo" disabled>
                                </div>
                            </div> --}}

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 150px;">Manufacturing Order</div>
                                    </div>
                                    <select id="cmbManufacturingOrder" name="manufacturingOrder" class="form-control form-control-sm"></select>
                                </div>
                            </div>

                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 150px;">Reason</div>
                                    </div>
                                    <select id="cmbReason" name="reason" class="form-control form-control-sm"></select>
                                </div>
                            </div>

                            <!--<div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 150px;">Machine Number</div>
                                    </div>
                                    <select id="cmbMachine" name="machine" class="form-control form-control-sm"></select>
                                </div>
                            </div>!-->

                        </div>
                      

                        {{-- <div class="row">
                            <div class="col-md-12 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 150px;">Project Code</div>
                                    </div>
                                    <select id="cmbProjectCode" name="projectCode" class="form-control form-control-sm"></select>
                                </div>
                            </div>
                        </div> --}}

                        {{-- <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">First Weight</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm float" id="txtFirstWeight" autocomplete="off" oninput="computeNetWeight()">
                                </div>
                            </div>
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 145px;">First Weight Time</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtFirstWeightTime" name="firstWeightTime" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 110px;">Second Weight</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm float" id="txtSecondWeight" autocomplete="off" oninput="computeNetWeight()">
                                </div>
                            </div>
                            <div class="col-md-4 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 145px;">Second Weight Time</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtSecondWeightTime" name="secondWeightTime" autocomplete="off">
                                </div>
                            </div>
                        </div> --}}

                        <div class="row">
                            <div class="col-md-12 mt-1">
                                <div class="input-group mb-2 mr-sm-2">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text form-control form-control-sm" style="width: 100px;">Remarks</div>
                                    </div>
                                    <input type="text" class="form-control form-control-sm" id="txtRemarks" name="remarks">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <ul class="nav nav-pills mb-3" role="tablist" id="navMenuItem">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="pills-order-tab" data-toggle="pill" href="#tbOrder" role="tab" aria-controls="pills-order" aria-selected="true">Product</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="pills-product-tab" data-toggle="pill" href="#tbProduct" role="tab" aria-controls="pills-product" aria-selected="false" hidden>Other</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="tbOrder" role="tabpanel" aria-labelledby="pills-order-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="table-responsive">
                                                    <table class="table table-sm table-striped" id="tblData"></table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane fade" id="tbProduct" role="tabpanel" aria-labelledby="pills-product-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <table class="table table-sm table-striped" id="tblOther"></table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>




                        <div class="row border">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12 mt-2 mb-2" style="text-align: right;">
                                        <button id="btnSave" class="btn btn-light form-control-sm">Save</button>
                                    </div>
                                </div>
                                <div class="row status_btn">
                                    <div class="col-md-12 mb-3" style="text-align: left;">
                                        <button type="button" class="btn btn-success text-success form-control-sm" id="btnApprove">Approve</i></button>
                                        <button type="button" class="btn btn-danger text-danger form-control-sm" id="btnReject">Reject</i></button>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>

        </div>
    </div>

    <div id="productChooser"></div>
    <div id="supplierChooser"></div>
    <div id="bomModalDiv"></div>

    <!-- JQuery !-->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    @endsection

    @section('script')
    <!-- Datepicker -->
    <script src="{{ url('vendors/datepicker/daterangepicker.js') }}"></script>
    <!-- AutoComplete -->
    <script src="{{ Module::asset('sc:js/autocomplete/js/autocomplete.min.js') }}?random=<?php echo uniqid(); ?>"></script>
    <!-- Datachooser -->
    <script src="{{ url('vendors/dataTable/datatables.min.js') }}"></script>
    <script src="{{ Module::asset('sc:js/data_chooser.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/BomModal.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/transaction_table.js') }}?random=<?php echo uniqid(); ?>"></script>

    <script src="{{ Module::asset('sc:js/id_gen.js') }}?random=<?php echo uniqid(); ?>"></script>
    <script src="{{ Module::asset('sc:js/raw_material_requisition_view.js') }}?random=<?php echo uniqid(); ?>"></script>





    @endsection