<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\Sc\Http\Controllers\AvailableQuantityBeforeSaveController;
use Modules\Sc\Http\Controllers\GoodsReceivedMrController;
use Modules\Sc\Http\Controllers\GoodsReceivedMrListController;
use Modules\Sc\Http\Controllers\GoodsReturnListController;
use Modules\Sc\Http\Controllers\GoodsTransferController;
use Modules\Sc\Http\Controllers\GoodsTransferListController;
use Modules\Sc\Http\Controllers\GoodsTransferMRController;
use Modules\Sc\Http\Controllers\GoodsTransferMRListController;
use Modules\Sc\Http\Controllers\GoodsTransferMrRetrieveController;
use Modules\Sc\Http\Controllers\GoodsTransferMrRetrieveContrommerController;
use Modules\Sc\Http\Controllers\GoodsTransferBagsController;
use Modules\Sc\Http\Controllers\GoodsTransferBagsListController;
use Modules\Sc\Http\Controllers\GrnHeaderController;
use Modules\Sc\Http\Controllers\GrnListController;
use Modules\Sc\Http\Controllers\GrnBagsHeaderController;
use Modules\Sc\Http\Controllers\GrnBagsListController;
use Modules\Sc\Http\Controllers\GrnReturnController;
use Modules\Sc\Http\Controllers\GoodsReturnBagsListController;
use Modules\Sc\Http\Controllers\GrnReturnBagsController;
use Modules\Sc\Http\Controllers\MaterialRequisitionController;
use Modules\Sc\Http\Controllers\MaterialRequisitionPendingListController;
use Modules\Sc\Http\Controllers\MaterialRequisitionBagsController;
use Modules\Sc\Http\Controllers\MaterialRequisitionBagsListController;
use Modules\Sc\Http\Controllers\RawMaterialRequisitionController;
use Modules\Sc\Http\Controllers\RawMaterialRequisitionListController;
use Modules\Sc\Http\Controllers\MaterialReturnController;
use Modules\Sc\Http\Controllers\MaterialReturnListController;
use Modules\Sc\Http\Controllers\MaterialReturnBagsListController;
use Modules\Sc\Http\Controllers\MaterialReturnBagsController;
use Modules\Sc\Http\Controllers\MaterialRiquisitionListController;
use Modules\Sc\Http\Controllers\MiHeaderControllrController;
use Modules\Sc\Http\Controllers\RawMiHeaderControllrController;
use Modules\Sc\Http\Controllers\MiBagsController;
use Modules\Sc\Http\Controllers\MiListController;
use Modules\Sc\Http\Controllers\MiBagsListController;
use Modules\Sc\Http\Controllers\RawMiListController;
use Modules\Sc\Http\Controllers\ProductHistoryController;
use Modules\Sc\Http\Controllers\ProductListReportController;
use Modules\Sc\Http\Controllers\PurchaseOrderController;
use Modules\Sc\Http\Controllers\PurchaseOrderListController;
use Modules\Sc\Http\Controllers\PurchaseRequestController;
use Modules\Sc\Http\Controllers\PurchaseRequestListController;
use Modules\Sc\Http\Controllers\ReferenceIDController;
use Modules\Sc\Http\Controllers\RetrieveMRController;
use Modules\Sc\Http\Controllers\RetrieveMRBagsController;
use Modules\Sc\Http\Controllers\RetrieveBagsMRController;
use Modules\Sc\Http\Controllers\RetrieveRawMRController;
use Modules\Sc\Http\Controllers\BagsCuttingDispatchController;
use Modules\Sc\Http\Controllers\BagsCuttingDispatchListController;
use Modules\Sc\Http\Controllers\BagsCuttingReturnListController;
use Modules\Sc\Http\Controllers\BagsCuttingReturnController;
use Modules\Sc\Http\Controllers\WeighBillController;
use Modules\Sc\Http\Controllers\SettingsController;
use Modules\Sc\Http\Controllers\StockReportController;
use Modules\Sc\Http\Controllers\StockValuationReportController;
use Modules\Sc\Http\Controllers\StockValuationBagsReportController;
use Modules\Sc\Http\Controllers\NotificationController;

Route::prefix('sc')->group(function () {

    Route::get('/dashboard', function () {
        return view('sc::dashboard');
    })->middleware('is.logged');

    Route::get('/grn', function () {
        return view('sc::grn_header');
    })->middleware(['is.logged', 'can:sc_goods_received_create']);

    Route::get('/grnList', function () {
        return view('sc::grn_list');
    })->middleware(['is.logged', 'can:sc_goods_received_list']);

    Route::get('/grnApproval', function () {
        return view('sc::grn_approval');
    })->middleware(['is.logged', 'can:sc_goods_received_approval']);

    

    Route::get('/materialIssue', function () {
        return view('sc::mi_header');
    })->middleware(['is.logged', 'can:sc_material_issue_create']);

    Route::get('/materialIssueList', function () {
        return view('sc::mi_list');
    })->middleware(['is.logged', 'can:sc_material_issue_list']);

    Route::get('/materialIssueApproval', function () {
        return view('sc::mi_approval');
    })->middleware(['is.logged', 'can:sc_material_issue_approval']);

    Route::get('/stockReport', function () {
        return view('sc::stock_report');
    })->middleware(['is.logged', 'can:sc_report_stock_balance']);


    Route::get('/productListReport', function () {
        return view('sc::product_list_report');
    })->middleware(['is.logged', 'can:sc_report_product_list']);


    Route::get('/settings', function () {
        return view('sc::settings');
    })->middleware(['is.logged', 'can:sc_setting']);

    Route::get('/materialReturn', function () {
        return view('sc::material_return');
    })->middleware(['is.logged', 'can:sc_material_return_create']);

    Route::get('/materialReturnList', function () {
        return view('sc::material_return_list');
    })->middleware(['is.logged', 'can:sc_material_return_list']);

    Route::get('/materialReturnApproval', function () {
        return view('sc::material_return_approvel');
    })->middleware(['is.logged', 'can:sc_material_return_approval']);

    Route::get('/productHistoryReport', function () {
        return view('sc::product_history_report');
    })->middleware(['is.logged', 'can:sc_report_product_history']);

    Route::get('/PurchaseRequest', function () {
        return view('sc::purchase_request');
    })->middleware(['is.logged', 'can:sc_purchase_request_create']);

    Route::get('/PurchaseRequestList', function () {
        return view('sc::purchase_request_list');
    })->middleware(['is.logged', 'can:sc_purchase_request_list']);

    Route::get('/PurchaseOrder', function () {
        return view('sc::purchase_order');
    })->middleware(['is.logged', 'can:sc_purchase_order_create']);

    Route::get('/PurchaseOrderList', function () {
        return view('sc::purchase_order_list');
    })->middleware(['is.logged', 'can:sc_purchase_order_list']);

    Route::get('/materialRequisition', function () {
        return view('sc::material_requisition');
    })->middleware(['is.logged', 'can:sc_material_request_create']);

    Route::get('/materialRequisitionView', function () {
        return view('sc::material_requisition_view');
    })->middleware(['is.logged', 'can:sc_material_request_create']);

    Route::get('/materialRequisitionList', function () {
        return view('sc::material_requisition_list');
    })->middleware(['is.logged', 'can:sc_material_request_list']);

    Route::get('/materialRequisitionPendingList', function () {
        return view('sc::material_requisition_pending_list');
    })->middleware(['is.logged', 'can:sc_material_request_list']);

    Route::get('/material_requisition_approval_list', function () {
        return view('sc::material_requisition_approval_list');
    })->middleware(['is.logged']);

    Route::get('/goodsReturn', function () {
        return view('sc::goods_return');
    })->middleware(['is.logged', 'can:sc_goods_return_create']);

    Route::get('/goodsReturnList', function () {
        return view('sc::goods_return_list');
    })->middleware(['is.logged', 'can:sc_goods_return_list']);

    Route::get('/goodsReturnApproval', function () {
        return view('sc::goods_return_approval');
    })->middleware(['is.logged', 'can:sc_goods_return_approval']);

    Route::get('/goods_received_mr', function () {
        return view('sc::goods_received_mr');
    })->middleware(['is.logged', 'can:sc_goods_received_m_r_create']);

    Route::get('/goods_received_mr_list', function () {
        return view('sc::goods_received_mr_list');
    })->middleware(['is.logged', 'can:sc_goods_received_m_r_list']);

    Route::get('/rawMaterialRequisition', function () {
        return view('sc::raw_material_requisition');
    })->middleware(['is.logged', 'can:sc_material_request_m_r_create']);

    Route::get('/rawMaterialRequisitionView', function () {
        return view('sc::raw_material_requisition_view');
    })->middleware(['is.logged', 'can:sc_material_request_m_r_create']);

    Route::get('/rawMaterialRequisitionList', function () {
        return view('sc::raw_material_requisition_list');
    })->middleware(['is.logged', 'can:sc_material_request_m_r_list']);
    

    Route::get('/rawMaterialIssue', function () {
        return view('sc::raw_material_issue');
    })->middleware(['is.logged', 'can:sc_material_issue_m_r_create']);

    Route::get('/rawMaterialIssueList', function () {
        return view('sc::raw_material_issue_list');
    })->middleware(['is.logged', 'can:sc_material_issue_m_r_list']);

    Route::get('/goods_transfer', function () {
        return view('sc::goods_transfer');
    })->middleware(['is.logged', 'can:sc_goods_transfer_create']);

    Route::get('/goods_transfer_list', function () {
        return view('sc::goods_transfer_list');
    })->middleware(['is.logged', 'can:sc_goods_transfer_list']);

    Route::get('/goods_transfer_approval', function () {
        return view('sc::goods_transfer_approval');
    })->middleware(['is.logged', 'can:sc_goods_transfer_approval']);


    Route::get('/BomModal', function () {
        return view('sc::BomModal');
    })->middleware(['is.logged']);

    Route::get('/goods_transfer_mr', function () {
        return view('sc::goods_transfer_mr');
    })->middleware(['is.logged', 'can:sc_goods_transfer_m_r_create']);

    Route::get('/goods_transfer_mr_list', function () {
        return view('sc::goods_transfer_mr_list');
    })->middleware(['is.logged', 'can:sc_goods_transfer_m_r_list']);

    Route::get('/report', function () {
        return view('sc::report');
    })->middleware(['is.logged']);

    Route::get('/bags_report', function () {
        return view('sc::bags_report');
    })->middleware(['is.logged']);

    Route::get('/grn_reports', function () {
        return view('sc::grn_reports');
    })->middleware(['is.logged']);



    Route::get('/goods_received_bags', function () {
        return view('sc::goods_received_bags');
    })->middleware(['is.logged', 'can:sc_goods_received_bags_create']);

    Route::get('/goods_received_bags_list', function () {
        return view('sc::goods_received_bags_list');
    })->middleware(['is.logged', 'can:sc_goods_received_bags_list']);

    Route::get('/goods_received_bags_approval', function () {
        return view('sc::goods_received_bags_approval');
    })->middleware(['is.logged', 'can:sc_goods_received_bags_approval']);



    Route::get('/material_requisition_bags', function () {
        return view('sc::material_requisition_bags');
    })->middleware(['is.logged', 'can:sc_material_request_bags_create']);

    Route::get('/material_requisition_bags_view', function () {
        return view('sc::material_requisition_bags_view');
    })->middleware(['is.logged', 'can:sc_material_request_bags_create']);

    Route::get('/material_requisition_bags_list', function () {
        return view('sc::material_requisition_bags_list');
    })->middleware(['is.logged', 'can:sc_material_request_bags_list']);

    Route::get('/material_requisition_bags_approval_list', function () {
        return view('sc::material_requisition_bags_approval_list');
    })->middleware(['is.logged', 'can:sc_material_request_bags_approval']);


    Route::get('/material_issues_bags', function () {
        return view('sc::material_issues_bags');
    })->middleware(['is.logged', 'can:sc_material_issue_bags_create']);

    Route::get('/material_issues_bags_list', function () {
        return view('sc::material_issues_bags_list');
    })->middleware(['is.logged', 'can:sc_material_issue_bags_list']);

    Route::get('/material_issues_bags_approval', function () {
        return view('sc::material_issues_bags_approval');
    })->middleware(['is.logged', 'can:sc_material_issue_bags_approval']);


    Route::get('/material_return_bags', function () {
        return view('sc::material_return_bags');
    })->middleware(['is.logged', 'can:sc_material_return_bags_create']);

    Route::get('/material_return_bags_list', function () {
        return view('sc::material_return_bags_list');
    })->middleware(['is.logged', 'can:sc_material_return_bags_list']);

    Route::get('/material_return_bags_approval', function () {
        return view('sc::material_return_bags_approval');
    })->middleware(['is.logged', 'can:sc_material_return_bags_approval']);


    Route::get('/goods_transfer_bags', function () {
        return view('sc::goods_transfer_bags');
    })->middleware(['is.logged', 'can:sc_goods_transfer_bags_create']);

    Route::get('/goods_transfer_bags_list', function () {
        return view('sc::goods_transfer_bags_list');
    })->middleware(['is.logged', 'can:sc_goods_transfer_bags_list']);

    Route::get('/goods_transfer_bags_approval', function () {
        return view('sc::goods_transfer_bags_approval');
    })->middleware(['is.logged', 'can:sc_goods_transfer_bags_approval']);


    Route::get('/goods_return_bags', function () {
        return view('sc::goods_return_bags');
    })->middleware(['is.logged', 'can:sc_goods_return_bags_create']);

    Route::get('/goods_return_bags_list', function () {
        return view('sc::goods_return_bags_list');
    })->middleware(['is.logged', 'can:sc_goods_return_bags_list']);

    Route::get('/goods_return_bags_approval', function () {
        return view('sc::goods_return_bags_approval');
    })->middleware(['is.logged', 'can:sc_goods_return_bags_approval']);


    Route::get('/bags_cutting_dispatch', function () {
        return view('sc::bags_cutting_dispatch');
    })->middleware(['is.logged']);

    Route::get('/bags_cutting_dispatch_list', function () {
        return view('sc::bags_cutting_dispatch_list');
    })->middleware(['is.logged',]);

    Route::get('/bags_cutting_dispatch_approval', function () {
        return view('sc::bags_cutting_dispatch_approval');
    })->middleware(['is.logged', ]);


    Route::get('/bags_cutting_return', function () {
        return view('sc::bags_cutting_return');
    })->middleware(['is.logged']);

    Route::get('/bags_cutting_return_list', function () {
        return view('sc::bags_cutting_return_list');
    })->middleware(['is.logged',]);

    Route::get('/bags_cutting_return_approval', function () {
        return view('sc::bags_cutting_return_approval');
    })->middleware(['is.logged', ]);


    /** Weigh Bill */
    Route::get('/weigh_bill', function () {
        return view('sc::weigh_bill');
    })->middleware(['is.logged',]);

    Route::get('/weigh_bill_list', function () {
        return view('sc::weigh_bill_list');
    })->middleware(['is.logged',]);


    /**ReferenceIDController */
    Route::get('/ReferenceIDController/grnHeaderMaxID/{store_id}', [ReferenceIDController::class, 'grnHeaderMaxID']);
    Route::get('/ReferenceIDController/grnReturnMaxID/{store_id}', [ReferenceIDController::class, 'grnReturnMaxID']);
    Route::get('/ReferenceIDController/miHeaderMaxID/{store_id}', [ReferenceIDController::class, 'miHeaderMaxID']);
    Route::get('/ReferenceIDController/purchaseRequestMaxID/{store_id}', [ReferenceIDController::class, 'purchaseRequestMaxID']);
    Route::get('/ReferenceIDController/purchaseOrderMaxID/{store_id}', [ReferenceIDController::class, 'purchaseOrderMaxID']);
    Route::get('/ReferenceIDController/materialRequisitionMaxIDMaxID/{store_id}', [ReferenceIDController::class, 'materialRequisitionMaxIDMaxID']);
    Route::get('/ReferenceIDController/rawMaterialRequisitionMaxIDMaxID/{store_id}', [ReferenceIDController::class, 'rawMaterialRequisitionMaxIDMaxID']);

    Route::get('/ReferenceIDController/goodsReceivedMrMaxID/{store_id}', [ReferenceIDController::class, 'goodsReceivedMrMaxID']);
    Route::get('/ReferenceIDController/goodsTransferMaxID/{store_id}', [ReferenceIDController::class, 'goodsTransferMaxID']);
    Route::get('/ReferenceIDController/goodsTransferMRMaxID/{store_id}', [ReferenceIDController::class, 'goodsTransferMRMaxID']);
    Route::get('/ReferenceIDController/materialIssueMaxID/{store_id}', [ReferenceIDController::class, 'materialIssueMaxID']);
    Route::get('/ReferenceIDController/rawMaterialIssueMaxID/{store_id}', [ReferenceIDController::class, 'rawMaterialIssueMaxID']);

    Route::get('/ReferenceIDController/materialReturnMaxID/{store_id}', [ReferenceIDController::class, 'materialReturnMaxID']);
    Route::get('/ReferenceIDController/goodsReceivedBagsMaxID/{store_id}', [ReferenceIDController::class, 'goodsReceivedBagsMaxID']);
    Route::get('/ReferenceIDController/materialRequisitionBagsMaxID/{store_id}', [ReferenceIDController::class, 'materialRequisitionBagsMaxID']);
    Route::get('/ReferenceIDController/materialIssueBagsMaxID/{store_id}', [ReferenceIDController::class, 'materialIssueBagsMaxID']);
    Route::get('/ReferenceIDController/materialReturnBagsHeaderMaxID/{store_id}', [ReferenceIDController::class, 'materialReturnBagsHeaderMaxID']);
    Route::get('/ReferenceIDController/goodsTransferBagsMaxID/{store_id}', [ReferenceIDController::class, 'goodsTransferBagsMaxID']);
    Route::get('/ReferenceIDController/grnReturnBagsMaxID/{store_id}', [ReferenceIDController::class, 'grnReturnBagsMaxID']);
    Route::get('/ReferenceIDController/bagsCuttingDispatchMaxID/{store_id}', [ReferenceIDController::class, 'bagsCuttingDispatchMaxID']);
    Route::get('/ReferenceIDController/bagsCuttingReturnMaxID/{store_id}', [ReferenceIDController::class, 'bagsCuttingReturnMaxID']);

    Route::get('/ReferenceIDController/weighBillMaxID/{store_id}', [ReferenceIDController::class, 'weighBillMaxID']);

    /**End of ReferenceIDController */


    /**Grn Header Controller */
    Route::get('/grnHeaderController/allEmployees', [GrnHeaderController::class, 'allEmployees']);
    Route::get('/grnHeaderController/allSuppliers', [GrnHeaderController::class, 'allSuppliers']);
    Route::get('/grnHeaderController/allProduct', [GrnHeaderController::class, 'allProduct']);
    Route::get('/grnHeaderController/allStores', [GrnHeaderController::class, 'allStores']);
    Route::get('/grnHeaderController/isApproved/{id}', [GrnHeaderController::class, 'isApproved']);
    Route::get('/grnHeaderController/getGrn/{id}', [GrnHeaderController::class, 'getGrn']);
    Route::get('/grnHeaderController/getUom/{id}', [GrnHeaderController::class, 'getUom']);
    Route::post('/grnHeaderController/save', [GrnHeaderController::class, 'save']);
    Route::put('/grnHeaderController/update/{id}', [GrnHeaderController::class, 'update']);
    Route::put('/grnHeaderController/change_status/{id}', [GrnHeaderController::class, 'change_status']);
    Route::post('/grnHeaderController/uploadAttachment', [GrnHeaderController::class, 'uploadAttachment'])->name('/grnHeaderController/uploadAttachment');
    Route::get('/grnHeaderController/allAttachment/{id}/{token}', [GrnHeaderController::class, 'allAttachment']);
    Route::get('/grnHeaderController/getPoFromSupplier/{id}', [GrnHeaderController::class, 'getPoFromSupplier']);
    /**End of Grn Header Controller */

    /**Grn List Controller */
    Route::get('/grnListController/allGrn', [GrnListController::class, 'allGrn']);
    Route::get('/grnListController/goodsReceivedReport/{id}', [GrnListController::class, 'goodsReceivedReport']);
    /**End of Grn List Controller */
        
    Route::get('/grnListController/allGrnForApprove', [GrnListController::class, 'allGrnForApprove']);




    /**Bags Grn Header Controller */
    Route::get('/grnBagsHeaderController/allEmployees', [GrnBagsHeaderController::class, 'allEmployees']);
    Route::get('/grnBagsHeaderController/allSuppliers', [GrnBagsHeaderController::class, 'allSuppliers']);
    Route::get('/grnBagsHeaderController/allProduct', [GrnBagsHeaderController::class, 'allProduct']);
    Route::get('/grnBagsHeaderController/allStores', [GrnBagsHeaderController::class, 'allStores']);
    Route::post('/grnBagsHeaderController/save', [GrnBagsHeaderController::class, 'save']);
    Route::get('/grnBagsHeaderController/getGrn/{id}', [GrnBagsHeaderController::class, 'getGrn']);
    Route::put('/grnBagsHeaderController/update/{id}', [GrnBagsHeaderController::class, 'update']);
    Route::get('/grnBagsHeaderController/getUom/{id}', [GrnBagsHeaderController::class, 'getUom']);
    Route::get('/grnBagsHeaderController/isApproved/{id}', [GrnBagsHeaderController::class, 'isApproved']);
    Route::get('/grnBagsHeaderController/allAttachment/{id}/{token}', [GrnBagsHeaderController::class, 'allAttachment']);
    Route::get('/grnBagsHeaderController/getPoFromSupplier/{id}', [GrnBagsHeaderController::class, 'getPoFromSupplier']);
    Route::put('/grnBagsHeaderController/change_status/{id}', [GrnBagsHeaderController::class, 'change_status']);
    Route::get('/grnBagsHeaderController/allCustomerOrderPlan', [GrnBagsHeaderController::class, 'allCustomerOrderPlan']);
    Route::get('/grnBagsHeaderController/allProductCustomer', [GrnBagsHeaderController::class, 'allProductCustomer']);

    Route::get('/grnBagsHeaderController/getGrn/{id}', [GrnBagsHeaderController::class, 'getGrn']);
    Route::post('/grnBagsHeaderController/uploadAttachment', [GrnBagsHeaderController::class, 'uploadAttachment'])->name('/grnBagsHeaderController/uploadAttachment');
    /**End of Bags Grn Header Controller */

    /** Bags Grn List Controller */
    Route::get('/grnBagsListController/allGrn', [GrnBagsListController::class, 'allGrn']);
    Route::get('/grnBagsListController/goodsReceivedReport/{id}', [GrnBagsListController::class, 'goodsReceivedReport']);
    /**End of Bags Grn List Controller */

    /**Grn Return Controller */
    Route::get('/grnReturnController/allEmployees', [GrnReturnController::class, 'allEmployees']);
    Route::get('/grnReturnController/allProjects', [GrnReturnController::class, 'allProjects']);
    Route::get('/grnReturnController/allSuppliers', [GrnReturnController::class, 'allSuppliers']);
    Route::get('/grnReturnController/allProduct', [GrnReturnController::class, 'allProduct']);
    Route::get('/grnReturnController/getUom/{id}', [GrnReturnController::class, 'getUom']);
    Route::get('/grnReturnController/allStores', [GrnReturnController::class, 'allStores']);
    Route::get('/grnReturnController/getGrn/{id}', [GrnReturnController::class, 'getGrn']);
    Route::get('/grnReturnController/getGoodsReturn/{id}', [GrnReturnController::class, 'getGoodsReturn']);
    Route::get('/grnReturnController/getQty/{product_id}/{store_id}', [GrnReturnController::class, 'getQty']);
    Route::get('/grnReturnController/allGrn', [GrnReturnController::class, 'allGrn']);
    Route::get('/grnReturnController/allProductUnit', [GrnReturnController::class, 'allProductUnit']);
    Route::post('/grnReturnController/save', [GrnReturnController::class, 'save']);
    Route::put('/grnReturnController/update/{id}', [GrnReturnController::class, 'update']);
    /**End of Grn Return Controller */

    /**Goods Return List Controller */
    Route::get('/goodsReturnListController/allGoodsReturn', [GoodsReturnListController::class, 'allGoodsReturn']);
    Route::get('/goodsReturnListController/goodsReturnReport/{id}', [GoodsReturnListController::class, 'goodsReturnReport']);
    Route::delete('/goodsReturnListController/deleteGoodsReturn/{id}', [GoodsReturnListController::class, 'deleteGoodsReturn']);
    Route::put('/goodsReturnListController/change_status/{id}', [GoodsReturnListController::class, 'change_status']);
    /**End of Goods Return Controller */



    /**Grn Return Bags Controller */
    Route::get('/grnReturnBagsController/allEmployees', [GrnReturnBagsController::class, 'allEmployees']);
    Route::get('/grnReturnBagsController/allProjects', [GrnReturnBagsController::class, 'allProjects']);
    Route::get('/grnReturnBagsController/allSuppliers', [GrnReturnBagsController::class, 'allSuppliers']);
    Route::get('/grnReturnBagsController/allProduct', [GrnReturnBagsController::class, 'allProduct']);
    Route::get('/grnReturnBagsController/getUom/{id}', [GrnReturnBagsController::class, 'getUom']);
    Route::get('/grnReturnBagsController/allStores', [GrnReturnBagsController::class, 'allStores']);
    Route::get('/grnReturnBagsController/getGrn/{id}', [GrnReturnBagsController::class, 'getGrn']);
    Route::get('/grnReturnBagsController/getGoodsReturn/{id}', [GrnReturnBagsController::class, 'getGoodsReturn']);
    Route::get('/grnReturnBagsController/getQty/{product_id}/{store_id}', [GrnReturnBagsController::class, 'getQty']);
    Route::get('/grnReturnBagsController/allGrn', [GrnReturnBagsController::class, 'allGrn']);
    Route::get('/grnReturnBagsController/allProductUnit', [GrnReturnBagsController::class, 'allProductUnit']);
    Route::post('/grnReturnBagsController/save', [GrnReturnBagsController::class, 'save']);
    Route::put('/grnReturnBagsController/update/{id}', [GrnReturnBagsController::class, 'update']);
    Route::get('/grnReturnBagsController/allProductCustomer', [GrnReturnBagsController::class, 'allProductCustomer']);

    /**End of Grn Return Bags Controller */

    /**Goods Return List Controller */
    Route::get('/goodsReturnBagsListController/allGoodsReturn', [GoodsReturnBagsListController::class, 'allGoodsReturn']);
    Route::get('/goodsReturnBagsListController/goodsReturnReport/{id}', [GoodsReturnBagsListController::class, 'goodsReturnReport']);
    Route::delete('/goodsReturnBagsListController/deleteGoodsReturn/{id}', [GoodsReturnBagsListController::class, 'deleteGoodsReturn']);
    Route::put('/goodsReturnBagsListController/change_status/{id}', [GoodsReturnBagsListController::class, 'change_status']);
    /**End of Goods Return Controller */



    /**Mi Header Controller */
    Route::get('/miHeaderController/allEmployees', [MiHeaderControllrController::class, 'allEmployees']);
    Route::get('/miHeaderController/allProjects', [MiHeaderControllrController::class, 'allProjects']);
    Route::get('/miHeaderController/allDepartment', [MiHeaderControllrController::class, 'allDepartment']);
    Route::get('/miHeaderController/allProduct', [MiHeaderControllrController::class, 'allProduct']);
    Route::get('/miHeaderController/allStores', [MiHeaderControllrController::class, 'allStores']);
    Route::get('/miHeaderController/allMachine', [MiHeaderControllrController::class, 'allMachinery']);
    Route::get('/miHeaderController/getMaterialIssue/{id}', [MiHeaderControllrController::class, 'getMaterialIssue']);
    Route::get('/miHeaderController/allProductUnit', [MiHeaderControllrController::class, 'allProductUnit']);
    Route::get('/miHeaderController/allProductCustomer', [MiHeaderControllrController::class, 'allProductCustomer']);
    Route::get('/miHeaderController/getQty/{product_id}/{store_id}', [MiHeaderControllrController::class, 'getQty']);
    Route::get('/miHeaderController/getUom/{id}', [MiHeaderControllrController::class, 'getUom']);
    Route::post('/miHeaderController/save', [MiHeaderControllrController::class, 'save']);
    Route::put('/miHeaderController/update/{id}', [MiHeaderControllrController::class, 'update']);
    Route::put('/miHeaderController/change_status/{id}', [MiHeaderControllrController::class, 'change_status']);
    Route::get('/miHeaderController/isApproved/{id}', [MiHeaderControllrController::class, 'isApproved']);
    Route::delete('/miHeaderController/deleteMaterialIssue/{id}', [MiHeaderControllrController::class, 'deleteMaterialIssue']);
    /**End of Mi Header Controller */

    /**Mi List Controller */
    Route::get('/miListController/allMaterialIssue', [MiListController::class, 'allMaterialIssue']);
    Route::get('/miListController/materialIssueReport/{id}', [MiListController::class, 'materialIssueReport']);
    /**End of Mi List Controller */



    /**Mi bags Header Controller */
    Route::get('/MiBagsController/allEmployees', [MiBagsController::class, 'allEmployees']);
    Route::get('/MiBagsController/allProjects', [MiBagsController::class, 'allProjects']);
    Route::get('/MiBagsController/allDepartment', [MiBagsController::class, 'allDepartment']);
    Route::get('/MiBagsController/allProduct', [MiBagsController::class, 'allProduct']);
    Route::get('/MiBagsController/allStores', [MiBagsController::class, 'allStores']);
    Route::get('/MiBagsController/allMachine', [MiBagsController::class, 'allMachinery']);
    Route::get('/MiBagsController/getMaterialIssue/{id}', [MiBagsController::class, 'getMaterialIssue']);
    Route::get('/MiBagsController/allProductUnit', [MiBagsController::class, 'allProductUnit']);
    Route::get('/MiBagsController/allProductCustomer', [MiBagsController::class, 'allProductCustomer']);
    Route::get('/MiBagsController/getQty/{product_id}/{store_id}', [MiBagsController::class, 'getQty']);
    Route::get('/MiBagsController/getUom/{id}', [MiBagsController::class, 'getUom']);
    Route::post('/MiBagsController/save', [MiBagsController::class, 'save']);
    Route::put('/MiBagsController/update/{id}', [MiBagsController::class, 'update']);
    Route::put('/MiBagsController/change_status/{id}', [MiBagsController::class, 'change_status']);
    Route::get('/MiBagsController/isApproved/{id}', [MiBagsController::class, 'isApproved']);
    Route::delete('/MiBagsController/deleteMaterialIssue/{id}', [MiBagsController::class, 'deleteMaterialIssue']);
    /**End of Mi bags Header Controller */

    /**Mi bags List Controller */
    Route::get('/MiBagsListController/allMaterialIssue', [MiBagsListController::class, 'allMaterialIssue']);
    Route::get('/MiBagsListController/materialIssueReport/{id}', [MiBagsListController::class, 'materialIssueReport']);
    /**End of Mi bags List Controller */



    /**Raw Mi Header Controller */
    Route::get('/rawMiHeaderController/allEmployees', [RawMiHeaderControllrController::class, 'allEmployees']);
    Route::get('/rawMiHeaderController/allProjects', [RawMiHeaderControllrController::class, 'allProjects']);
    Route::get('/rawMiHeaderController/allDepartment', [RawMiHeaderControllrController::class, 'allDepartment']);
    Route::get('/rawMiHeaderController/allProduct', [RawMiHeaderControllrController::class, 'allProduct']);
    Route::get('/rawMiHeaderController/allStores', [RawMiHeaderControllrController::class, 'allStores']);
    Route::get('/rawMiHeaderController/allMachine', [RawMiHeaderControllrController::class, 'allMachinery']);
    Route::get('/rawMiHeaderController/allProductUnit', [RawMiHeaderControllrController::class, 'allProductUnit']);
    Route::get('/rawMiHeaderController/allProductCustomer', [RawMiHeaderControllrController::class, 'allProductCustomer']);
    Route::get('/rawMiHeaderController/getQty/{product_id}/{store_id}', [RawMiHeaderControllrController::class, 'getQty']);
    Route::get('/rawMiHeaderController/getUom/{id}', [RawMiHeaderControllrController::class, 'getUom']);
    Route::put('/rawMiHeaderController/change_status/{id}', [RawMiHeaderControllrController::class, 'change_status']);
    Route::get('/rawMiHeaderController/isApproved/{id}', [RawMiHeaderControllrController::class, 'isApproved']);
    Route::delete('/rawMiHeaderController/deleteRawMaterialIssue/{id}', [RawMiHeaderControllrController::class, 'deleteMaterialIssue']);

    Route::get('/rawMiHeaderController/getRawMaterialIssue/{id}', [RawMiHeaderControllrController::class, 'getRawMaterialIssue']);
    Route::post('/rawMiHeaderController/save', [RawMiHeaderControllrController::class, 'save']);
    Route::put('/rawMiHeaderController/update/{id}', [RawMiHeaderControllrController::class, 'update']);

    /**End of raw Mi Header Controller */

    /**raw Mi List Controller */
    Route::get('/rawMiListController/allRawMaterialIssue', [RawMiListController::class, 'allRawMaterialIssue']);
    Route::get('/rawMiListController/rawMaterialIssueReport/{id}', [RawMiListController::class, 'rawMaterialIssueReport']);
    /**raw End of Mi List Controller */


    /** Stock Report */
    Route::get('/stockReport/allSettings', [StockReportController::class, 'allSettings']);
    Route::get('/stockReport/category_level2/{id}', [StockReportController::class, 'category_level2']);
    Route::get('/stockReport/category_level3/{id}', [StockReportController::class, 'category_level3']);
    Route::get('/stockReport/stockBalanceReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'stockBalanceReport']);
    Route::get('/stockReport/stockBalanceAsAtReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'stockBalanceAsAtReport']);
    
    Route::get('/stockReport/productHistoryReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'productHistoryReport']);
    Route::get('/stockReport/purchaseOrderReport/{setting}/{date_from}/{date_to}', [StockReportController::class, 'purchaseOrderReport']);
    /** End of Stock Report */


    /** Product List Report */
    Route::get('/productListReport/allSettings', [ProductListReportController::class, 'allSettings']);
    Route::get('/productListReport/Report/{setting}/{date_from}/{date_to}', [ProductListReportController::class, 'productListReport']);
    /** End of Product List Report */


    /** Product History Report */
    Route::get('/producrtHistoryReport/allSettings', [ProductHistoryController::class, 'allSettings']);
    Route::get('/producrtHistoryReport/productHistoryReport/{setting}/{date_from}/{date_to}', [ProductHistoryController::class, 'productHistoryReport']);
    /** End of Product History Report */


    /** Settings */
    Route::get('/settings/allStores', [SettingsController::class, 'allStores']);
    Route::get('/settings/allSite', [SettingsController::class, 'allSite']);
    Route::post('/settingController/saveStores', [SettingsController::class, 'saveStores']);
    Route::post('/settingController/saveOrderType', [SettingsController::class, 'saveOrderType']);
    Route::post('/settingController/saveMaterialRequestReason', [SettingsController::class, 'saveMaterialRequestReason']);
    Route::post('/settingController/saveBagCuttingCenter', [SettingsController::class, 'saveBagCuttingCenter']);
    Route::post('/settingController/saveMaterialPlant', [SettingsController::class, 'saveMaterialPlants']);

    Route::get('/stockController/getAllStores', [SettingsController::class, 'getAllStores']);
    Route::get('/stockController/getAllOrderType', [SettingsController::class, 'getAllOrderType']);
    Route::get('/stockController/getAllMaterialRequestReason', [SettingsController::class, 'getAllMaterialRequestReason']);
    Route::get('/stockController/getAllBagCuttingCenter', [SettingsController::class, 'getAllBagCuttingCenter']);
    Route::get('/stockController/getAllMaterialPlants', [SettingsController::class, 'getAllMaterialPlants']);

    Route::get('/stockController/getOrderType/{id}', [SettingsController::class, 'getOrderType']);
    Route::get('/stockController/getStore/{id}', [SettingsController::class, 'getStore']);
    Route::get('/stockController/getMaterialRequestReason/{id}', [SettingsController::class, 'getMaterialRequestReason']);
    Route::get('/stockController/getBagCuttingCenter/{id}', [SettingsController::class, 'getBagCuttingCenter']);
    Route::get('/stockController/getMaterialPlant/{id}', [SettingsController::class, 'getMaterialPlant']);

    Route::put('/stockController/updateOrderType/{id}', [SettingsController::class, 'updateOrderType']);
    Route::put('/stockController/updateStores/{id}', [SettingsController::class, 'updateStores']);
    Route::put('/stockController/updateMaterialRequestReason/{id}', [SettingsController::class, 'updateMaterialRequestReason']);
    Route::put('/stockController/updateBagCuttingCenter/{id}', [SettingsController::class, 'updateBagCuttingCenter']);
    Route::put('/stockController/updateMaterialPlant/{id}', [SettingsController::class, 'updateMaterialPlant']);

    Route::put('/stockController/disableStores/{id}', [SettingsController::class, 'disableStores']);
    Route::put('/stockController/disableOrderType/{id}', [SettingsController::class, 'disableOrderType']);
    Route::put('/stockController/disableMaterialRequestReason/{id}', [SettingsController::class, 'disableMaterialRequestReason']);
    Route::put('/stockController/disableBagCuttingCenter/{id}', [SettingsController::class, 'disableBagCuttingCenter']);
    Route::put('/stockController/disableMaterialPlant/{id}', [SettingsController::class, 'disableMaterialPlant']);

    /** End of settings */


    /**Material Return Controller */
    Route::get('/MaterialReturnController/allEmployees', [MaterialReturnController::class, 'allEmployees']);
    Route::get('/MaterialReturnController/allProjects', [MaterialReturnController::class, 'allProjects']);
    Route::get('/MaterialReturnController/allDepartment', [MaterialReturnController::class, 'allDepartment']);
    Route::get('/MaterialReturnController/allProduct', [MaterialReturnController::class, 'allProduct']);
    Route::get('/MaterialReturnController/allStores', [MaterialReturnController::class, 'allStores']);
    Route::get('/MaterialReturnController/allMachine', [MaterialReturnController::class, 'allMachinery']);
    Route::get('/MaterialReturnController/allProductUnit', [MaterialReturnController::class, 'allProductUnit']);
    Route::get('/MaterialReturnController/allProductCustomer', [MaterialReturnController::class, 'allProductCustomer']);
    Route::get('/MaterialReturnController/allMi', [MaterialReturnController::class, 'allMi']);
    Route::get('/MaterialReturnController/getMaterialIssue/{id}', [MaterialReturnController::class, 'getMaterialIssue']);
    Route::get('/MaterialReturnController/getQty/{product_id}/{store_id}', [MaterialReturnController::class, 'getQty']);
    Route::get('/MaterialReturnController/getMaterialReturn/{id}', [MaterialReturnController::class, 'getMaterialReturn']);
    Route::get('/MaterialReturnController/getUom/{id}', [MaterialReturnController::class, 'getUom']);
    Route::post('/MaterialReturnController/save', [MaterialReturnController::class, 'save']);
    /**End of Material Return Controller */


    /**Material Return bags Controller */
    Route::get('/MaterialReturnBagsController/allEmployees', [MaterialReturnBagsController::class, 'allEmployees']);
    Route::get('/MaterialReturnBagsController/allSuppliers', [MaterialReturnBagsController::class, 'allSuppliers']);
    Route::get('/MaterialReturnBagsController/allProjects', [MaterialReturnBagsController::class, 'allProjects']);
    Route::get('/MaterialReturnBagsController/allDepartment', [MaterialReturnBagsController::class, 'allDepartment']);
    Route::get('/MaterialReturnBagsController/allProduct', [MaterialReturnBagsController::class, 'allProduct']);
    Route::get('/MaterialReturnBagsController/allStores', [MaterialReturnBagsController::class, 'allStores']);
    Route::get('/MaterialReturnBagsController/allMachine', [MaterialReturnBagsController::class, 'allMachinery']);
    Route::get('/MaterialReturnBagsController/allProductUnit', [MaterialReturnBagsController::class, 'allProductUnit']);
    Route::get('/MaterialReturnBagsController/allProductCustomer', [MaterialReturnBagsController::class, 'allProductCustomer']);
    Route::get('/MaterialReturnBagsController/allMi', [MaterialReturnBagsController::class, 'allMi']);
    Route::get('/MaterialReturnBagsController/getMaterialIssue/{id}', [MaterialReturnBagsController::class, 'getMaterialIssue']);
    Route::get('/MaterialReturnBagsController/getQty/{product_id}/{store_id}', [MaterialReturnBagsController::class, 'getQty']);
    Route::get('/MaterialReturnBagsController/getMaterialReturn/{id}', [MaterialReturnBagsController::class, 'getMaterialReturn']);
    Route::get('/MaterialReturnBagsController/getUom/{id}', [MaterialReturnBagsController::class, 'getUom']);
    Route::post('/MaterialReturnBagsController/save', [MaterialReturnBagsController::class, 'save']);
    Route::put('/MaterialReturnBagsController/change_status/{id}', [MaterialReturnBagsController::class, 'change_status']);

    /**End of Material Return bags Controller */


    /**Material Return Bags List Controller */
    Route::get('/materialReturnBagsListController/allMaterialReturn', [MaterialReturnBagsListController::class, 'allMaterialReturn']);
    Route::get('/materialReturnBagsListController/materialReturnReport/{id}', [MaterialReturnBagsListController::class, 'materialReturnReport']);
    /**Material Return Bags List Controller */


    /**Perchase Request Header Controller */
    Route::get('/perchaseRequestHeaderController/allEmployees', [PurchaseRequestController::class, 'allEmployees']);
    Route::get('/perchaseRequestHeaderController/allProjects', [PurchaseRequestController::class, 'allProjects']);
    Route::get('/perchaseRequestHeaderController/allDepartment', [PurchaseRequestController::class, 'allDepartment']);
    Route::get('/perchaseRequestHeaderController/allProduct', [PurchaseRequestController::class, 'allProduct']);
    Route::get('/perchaseRequestHeaderController/allStores', [PurchaseRequestController::class, 'allStores']);
    Route::get('/perchaseRequestHeaderController/getPurchaseRequest/{id}', [PurchaseRequestController::class, 'getPurchaseRequest']);
    Route::get('/perchaseRequestHeaderController/getPurchaseRequestByExternalID/{id}', [PurchaseRequestController::class, 'getPurchaseRequestByExternalID']);
    Route::get('/perchaseRequestHeaderController/allProductUnit', [PurchaseRequestController::class, 'allProductUnit']);
    Route::get('/perchaseRequestHeaderController/allProductCustomer', [PurchaseRequestController::class, 'allProductCustomer']);
    Route::get('/perchaseRequestHeaderController/getQty/{product_id}/{store_id}', [PurchaseRequestController::class, 'getQty']);
    Route::post('/perchaseRequestHeaderController/uploadAttachment', [PurchaseRequestController::class, 'uploadAttachment'])->name('/perchaseRequestHeaderController/uploadAttachment');
    Route::get('/perchaseRequestHeaderController/allAttachment/{id}/{token}', [PurchaseRequestController::class, 'allAttachment']);
    Route::post('/perchaseRequestHeaderController/save', [PurchaseRequestController::class, 'save']);
    Route::put('/perchaseRequestHeaderController/update/{id}', [PurchaseRequestController::class, 'update']);
    Route::put('/perchaseRequestHeaderController/approve/{id}', [PurchaseRequestController::class, 'approve']);
    Route::delete('/perchaseRequestHeaderController/deleteAttachment/{id}', [PurchaseRequestController::class, 'deleteAttachment']);
    /**End of Perchase Request Controller */



    /**Purchase Request List Controller */
    Route::get('/purchaseRequestListController/allPurchaseRequest', [PurchaseRequestListController::class, 'allPurchaseRequest']);
    Route::get('/purchaseRequestListController/allPr', [PurchaseRequestListController::class, 'allPr']);
    Route::delete('/purchaseRequestListController/deletePurchaseRequest/{id}', [PurchaseRequestListController::class, 'deletePurchaseRequest']);
    Route::get('/purchaseRequestListController/purchaseRequestReport/{id}', [PurchaseRequestListController::class, 'purchaseRequestReport']);
    Route::put('/purchaseRequestListController/change_status/{id}', [PurchaseRequestListController::class, 'change_status']);
    /**End of Purchase Request List Controller */





    /**Perchase Order Header Controller */
    Route::get('/perchaseOrderController/allEmployees', [PurchaseOrderController::class, 'allEmployees']);
    Route::get('/perchaseOrderController/allDepartment', [PurchaseOrderController::class, 'allDepartment']);
    Route::get('/perchaseOrderController/allProduct', [PurchaseOrderController::class, 'allProduct']);
    Route::get('/perchaseOrderController/allStores', [PurchaseOrderController::class, 'allStores']);
    Route::get('/perchaseOrderController/getPurchaseOrder/{id}', [PurchaseOrderController::class, 'getPurchaseOrder']);
    Route::get('/perchaseOrderController/getPurchaseOrderByExternalID/{id}', [PurchaseOrderController::class, 'getPurchaseOrderByExternalID']);

    Route::get('/perchaseOrderController/allProductUnit', [PurchaseOrderController::class, 'allProductUnit']);
    Route::get('/perchaseOrderController/allProductCustomer', [PurchaseOrderController::class, 'allProductCustomer']);
    Route::get('/perchaseOrderController/getQty/{product_id}/{store_id}', [PurchaseOrderController::class, 'getQty']);
    Route::get('/perchaseOrderController/allPayTerms', [PurchaseOrderController::class, 'allPayTerms']);
    Route::get('/perchaseOrderController/allOrderType', [PurchaseOrderController::class, 'allOrderType']);
    Route::get('/perchaseOrderController/getUom/{id}', [PurchaseOrderController::class, 'getUom']);
    Route::get('/perchaseOrderController/allCurrency', [PurchaseOrderController::class, 'allCurrency']);
    Route::get('/perchaseOrderController/allAttachment/{id}/{token}', [PurchaseOrderController::class, 'allAttachment']);

    Route::post('/perchaseOrderController/save', [PurchaseOrderController::class, 'save']);
    Route::put('/perchaseOrderController/update/{id}', [PurchaseOrderController::class, 'update']);
    Route::put('/perchaseOrderController/approve/{id}', [PurchaseOrderController::class, 'approve']);
    Route::post('/perchaseOrderController/uploadAttachment', [PurchaseOrderController::class, 'uploadAttachment'])->name('/perchaseOrderController/uploadAttachment');
    /**End of Perchase Order Controller */




    /**Purchase Order List Controller */
    Route::get('/purchaseOrderListController/allPurchaseOrder', [PurchaseOrderListController::class, 'allPurchaseOrder']);
    Route::get('/purchaseOrderListController/purchaseOrderReport/{id}', [PurchaseOrderListController::class, 'purchaseOrderReport']);
    Route::delete('/purchaseOrderListController/deletePurchaseOrder/{id}', [PurchaseOrderListController::class, 'deletePurchaseOrder']);
    Route::put('/purchaseOrderListController/change_status/{id}', [PurchaseOrderListController::class, 'change_status']);
    /**End of Purchase Order List Controller */





    /**Material Requisition Header Controller */
    Route::get('/materialRequisitionController/allEmployees', [MaterialRequisitionController::class, 'allEmployees']);
    Route::get('/materialRequisitionController/allProjects', [MaterialRequisitionController::class, 'allProjects']);
    Route::get('/materialRequisitionController/allDepartment', [MaterialRequisitionController::class, 'allDepartment']);
    Route::get('/materialRequisitionController/allProduct', [MaterialRequisitionController::class, 'allProduct']);
    Route::get('/materialRequisitionController/allStores', [MaterialRequisitionController::class, 'allStores']);
    Route::get('/materialRequisitionController/allMachine', [MaterialRequisitionController::class, 'allMachinery']);
    Route::get('/materialRequisitionController/allMaterialRequestReason', [MaterialRequisitionController::class, 'allMaterialRequestReason']);
    Route::get('/materialRequisitionController/getMaterialRequisition/{id}', [MaterialRequisitionController::class, 'getMaterialRequisition']);
    Route::get('/materialRequisitionController/allProductUnit', [MaterialRequisitionController::class, 'allProductUnit']);
    Route::get('/materialRequisitionController/allProductCustomer', [MaterialRequisitionController::class, 'allProductCustomer']);
    Route::get('/materialRequisitionController/getQty/{product_id}/{store_id}', [MaterialRequisitionController::class, 'getQty']);
    Route::get('/materialRequisitionController/getUom/{id}', [MaterialRequisitionController::class, 'getUom']);
    Route::get('/materialRequisitionController/getScheduledFactoryPO', [MaterialRequisitionController::class, 'getScheduledFactoryPO']);
    Route::get('/materialRequisitionController/getProductFromOrder/{id}', [MaterialRequisitionController::class, 'getProductFromOrder']);
    Route::get('/materialRequisitionController/getBomHeader/{order_plan_data_id}', [MaterialRequisitionController::class, 'getBomHeader']);
    Route::get('/materialRequisitionController/setScheduleBom/{order_plan_data_id}/{product_id}', [MaterialRequisitionController::class, 'setScheduleBom']);

    Route::post('/materialRequisitionController/save', [MaterialRequisitionController::class, 'save']);
    Route::put('/materialRequisitionController/update/{id}', [MaterialRequisitionController::class, 'update']);
    Route::put('/materialRequisitionController/approve/{id}', [MaterialRequisitionController::class, 'approve']);
    /**End of Material Requisition Header Controller */

    /** Material Requisition List Controller */
    Route::get('/materialRequisitionListController/allMaterialRequisition/{department}/{status}', [MaterialRiquisitionListController::class, 'allMaterialRequisition']);
    Route::get('/materialRequisitionListController/allMaterialApprovalRequisition', [MaterialRiquisitionListController::class, 'allMaterialApprovalRequisition']);
    Route::get('/materialRequisitionListController/materialRequisitionReport/{id}', [MaterialRiquisitionListController::class, 'materialRequisitionReport']);
    Route::put('/materialRequisitionListController/change_status/{id}', [MaterialRiquisitionListController::class, 'change_status']);
    Route::get('/materialRequisitionListController/loadDepartments', [MaterialRiquisitionListController::class, 'loadDepartments']);
    /**End of Material Requisition List Controller */

    /** Material Requisition Pending List Controller */
    Route::get('/materialRequisitionPendingListController/allMaterialRequisitionPending/{department}/{status}', [MaterialRequisitionPendingListController::class, 'allMaterialRequisitionPending']);
    /**End of Material Requisition Pending List Controller */

    /**Material Requisition Bags Header Controller */
    Route::get('/materialRequisitionBagsController/allEmployees', [MaterialRequisitionBagsController::class, 'allEmployees']);
    Route::get('/materialRequisitionBagsController/allProjects', [MaterialRequisitionBagsController::class, 'allProjects']);
    Route::get('/materialRequisitionBagsController/allDepartment', [MaterialRequisitionBagsController::class, 'allDepartment']);
    Route::get('/materialRequisitionBagsController/allProduct', [MaterialRequisitionBagsController::class, 'allProduct']);
    Route::get('/materialRequisitionBagsController/allStores', [MaterialRequisitionBagsController::class, 'allStores']);
    Route::get('/materialRequisitionBagsController/allMachine', [MaterialRequisitionBagsController::class, 'allMachinery']);
    Route::get('/materialRequisitionBagsController/getScheduledFactoryPO', [MaterialRequisitionBagsController::class, 'getScheduledFactoryPO']);
    Route::get('/materialRequisitionBagsController/allMaterialRequestReason', [MaterialRequisitionBagsController::class, 'allMaterialRequestReason']);
    Route::get('/materialRequisitionBagsController/getUom/{id}', [MaterialRequisitionBagsController::class, 'getUom']);
    Route::get('/materialRequisitionBagsController/setScheduleBom/{order_plan_data_id}/{product_id}', [MaterialRequisitionBagsController::class, 'setScheduleBom']);
    Route::get('/materialRequisitionBagsController/getBomHeader/{order_plan_data_id}', [MaterialRequisitionBagsController::class, 'getBomHeader']);
    Route::get('/materialRequisitionBagsController/getProductFromOrder/{id}', [MaterialRequisitionBagsController::class, 'getProductFromOrder']);
    Route::get('/materialRequisitionBagsController/getQty/{product_id}/{store_id}', [MaterialRequisitionBagsController::class, 'getQty']);
    Route::post('/materialRequisitionBagsController/save', [MaterialRequisitionBagsController::class, 'save']);
    Route::get('/materialRequisitionBagsController/getMaterialRequisition/{id}', [MaterialRequisitionBagsController::class, 'getMaterialRequisition']);
    Route::put('/materialRequisitionBagsController/update/{id}', [MaterialRequisitionBagsController::class, 'update']);


    //Route::put('/materialRequisitionBagsController/approve/{id}', [MaterialRequisitionBagsController::class, 'approve']);
    Route::get('/materialRequisitionBagsController/allProductUnit', [MaterialRequisitionBagsController::class, 'allProductUnit']);
    Route::get('/materialRequisitionBagsController/allProductCustomer', [MaterialRequisitionBagsController::class, 'allProductCustomer']);
    /**End of Material Requisition Bags Header Controller */


    /** Material Requisition  Bag List Controller */
    Route::get('/materialRequisitionBagsListController/allMaterialRequisition/{department}/{status}', [MaterialRequisitionBagsListController::class, 'allMaterialRequisition']);
    Route::get('/materialRequisitionBagsListController/allMaterialApprovalRequisition', [MaterialRequisitionBagsListController::class, 'allMaterialApprovalRequisition']);
    Route::get('/materialRequisitionBagsListController/materialRequisitionReport/{id}', [MaterialRequisitionBagsListController::class, 'materialRequisitionReport']);
    Route::put('/materialRequisitionBagsListController/change_status/{id}', [MaterialRequisitionBagsListController::class, 'change_status']);
    Route::get('/materialRequisitionBagsListController/loadDepartments', [MaterialRequisitionBagsListController::class, 'loadDepartments']);
    /**End of Material Requisition Bag List Controller */


    /** Retrieve MR Controller */
    Route::get('/retrieveBagsMRController/allMaterialRequisition', [RetrieveBagsMRController::class, 'allMaterialRequisition']);
    Route::get('/retrieveBagsMRController/allMaterialRequisitionData/{id}', [RetrieveBagsMRController::class, 'allMaterialRequisitionData']);
    Route::get('/retrieveBagsMRController/getSelectedMR/{id}', [RetrieveBagsMRController::class, 'getSelectedMR']);
    Route::get('/retrieveBagsMRController/getSelectedMRHeader/{id}', [RetrieveBagsMRController::class, 'getSelectedMRHeader']);
    Route::put('/retrieveBagsMRController/change_status/{id}', [RetrieveBagsMRController::class, 'change_status']);
    /** End of Retrieve MR Controller */



    

    /**Raw Material Requisition Controller */
    Route::get('/rawMaterialRequisitionController/allEmployees', [RawMaterialRequisitionController::class, 'allEmployees']);
    Route::get('/rawMaterialRequisitionController/allProjects', [RawMaterialRequisitionController::class, 'allProjects']);
    Route::get('/rawMaterialRequisitionController/allDepartment', [RawMaterialRequisitionController::class, 'allDepartment']);
    Route::get('/rawMaterialRequisitionController/allProduct', [RawMaterialRequisitionController::class, 'allProduct']);
    Route::get('/rawMaterialRequisitionController/allStores', [RawMaterialRequisitionController::class, 'allStores']);
    Route::get('/rawMaterialRequisitionController/allMachine', [RawMaterialRequisitionController::class, 'allMachinery']);
    Route::get('/rawMaterialRequisitionController/allProduct', [RawMaterialRequisitionController::class, 'allProduct']);
  
    Route::get('/rawMaterialRequisitionController/allMaterialRequestReason', [RawMaterialRequisitionController::class, 'allMaterialRequestReason']);
    Route::get('/rawMaterialRequisitionController/allProductUnit', [RawMaterialRequisitionController::class, 'allProductUnit']);
    Route::get('/rawMaterialRequisitionController/allProductCustomer', [RawMaterialRequisitionController::class, 'allProductCustomer']);
    Route::get('/rawMaterialRequisitionController/getQty/{product_id}/{store_id}', [RawMaterialRequisitionController::class, 'getQty']);
    Route::get('/rawMaterialRequisitionController/getUom/{id}', [RawMaterialRequisitionController::class, 'getUom']);
    Route::get('/rawMaterialRequisitionController/getScheduledFactoryPO', [RawMaterialRequisitionController::class, 'getScheduledFactoryPO']);
    Route::get('/rawMaterialRequisitionController/getProductFromOrder/{id}', [RawMaterialRequisitionController::class, 'getProductFromOrder']);
    Route::get('/rawMaterialRequisitionController/getBomHeader/{order_plan_data_id}', [RawMaterialRequisitionController::class, 'getBomHeader']);
    Route::get('/rawMaterialRequisitionController/setScheduleBom/{order_plan_data_id}/{product_id}', [RawMaterialRequisitionController::class, 'setScheduleBom']);

    Route::post('/rawMaterialRequisitionController/save', [RawMaterialRequisitionController::class, 'save']);
    Route::put('/rawMaterialRequisitionController/update/{id}', [RawMaterialRequisitionController::class, 'update']);
    Route::get('/rawMaterialRequisitionController/getRawMaterialRequisition/{id}', [RawMaterialRequisitionController::class, 'getRawMaterialRequisition']);
    Route::get('/rawMaterialRequisitionListController/rawMaterialRequisitionReport/{id}', [RawMaterialRequisitionController::class, 'rawMaterialRequisitionReport']);

    /**End of Raw Material Requisition Controller */

    /** Raw Material Requisition List Controller */
    Route::get('/rawMaterialRequisitionListController/allRawMaterialRequisition/{department}/{status}', [RawMaterialRequisitionListController::class, 'allRawMaterialRequisition']);
    Route::put('/rawMaterialRequisitionListController/change_status/{id}', [RawMaterialRequisitionListController::class, 'change_status']); 
    Route::get('/rawMaterialRequisitionListController/allMaterialApprovalRequisition', [RawMaterialRequisitionListController::class, 'allMaterialApprovalRequisition']);
    Route::get('/rawMaterialRequisitionListController/materialRequisitionReport/{id}', [RawMaterialRequisitionListController::class, 'materialRequisitionReport']);
    Route::get('/rawMaterialRequisitionListController/loadDepartments', [RawMaterialRequisitionListController::class, 'loadDepartments']);
    /**End of Raw Material Requisition List Controller */

    /** Retrieve MR Controller */
    Route::get('/RetrieveRawMRController/allRawMaterialRequisition', [RetrieveRawMRController::class, 'allRawMaterialRequisition']);
    Route::get('/RetrieveRawMRController/allRawMaterialRequisitionData/{id}', [RetrieveRawMRController::class, 'allRawMaterialRequisitionData']);
    Route::get('/RetrieveRawMRController/getSelectedRawMR/{id}', [RetrieveRawMRController::class, 'getSelectedRawMR']);
    Route::get('/RetrieveRawMRController/getSelectedRawMRHeader/{id}', [RetrieveRawMRController::class, 'getSelectedRawMRHeader']);
    Route::put('/RetrieveRawMRController/change_status/{id}', [RetrieveRawMRController::class, 'change_status']);
    /** End of Retrieve MR Controller */





    /**Material Return List Controller */
    Route::get('/materialReturnListController/allMaterialReturn', [MaterialReturnListController::class, 'allMaterialReturn']);
    Route::get('/materialReturnListController/materialReturnReport/{id}', [MaterialReturnListController::class, 'materialReturnReport']);
    /**Material Return List Controller */


    /** Goods Received MR */
    Route::get('/GoodsReceivedMrController/allProduct', [GoodsReceivedMrController::class, 'allProduct']);
    Route::get('/GoodsReceivedMrController/allStores', [GoodsReceivedMrController::class, 'allStores']);
    Route::get('/GoodsReceivedMrController/sites', [GoodsReceivedMrController::class, 'sites']);
    Route::get('/GoodsReceivedMrController/allProduct', [GoodsReceivedMrController::class, 'allProduct']);
    Route::get('/GoodsReceivedMrController/allSuppliers', [GoodsReceivedMrController::class, 'allSuppliers']);
    Route::get('/GoodsReceivedMrController/allPurchaseOrders', [GoodsReceivedMrController::class, 'allPurchaseOrders']);
    Route::get('/GoodsReceivedMrController/allMaterialPlants', [GoodsReceivedMrController::class, 'allMaterialPlants']);

    Route::get('/GoodsReceivedMrController/getSelectedGoodsReceivedMR/{id}', [GoodsReceivedMrController::class, 'getSelectedGoodsReceivedMR']);
    Route::post('/GoodsReceivedMrController/save', [GoodsReceivedMrController::class, 'save']);
    Route::put('/GoodsReceivedMrController/update/{id}', [GoodsReceivedMrController::class, 'update']);
    Route::put('/GoodsReceivedMrController/change_status/{id}', [GoodsReceivedMrController::class, 'change_status']);
    /** End of Goods Received MR */


    /** Goods Received MR List */
    Route::get('/GoodsReceivedMrListController/allGoodsReceivedMR', [GoodsReceivedMrListController::class, 'allGoodsReceivedMR']);
    Route::get('/GoodsReceivedMrListController/goodsReceivedMRReport/{id}', [GoodsReceivedMrListController::class, 'goodsReceivedMRReport']);
    Route::delete('/GoodsReceivedMrListController/delete/{id}', [GoodsReceivedMrListController::class, 'delete']);
    /** End Of Goods Received MR List */

    /** Weigh Bill Controller */
    Route::get('/WeighBillController/allProduct', [WeighBillController::class, 'allProduct']);
    Route::get('/WeighBillController/allSuppliers', [WeighBillController::class, 'allSuppliers']);
    Route::post('/WeighBillController/save', [WeighBillController::class, 'save']);

    Route::get('/WeighBillController/allWeighBills', [WeighBillController::class, 'allWeighBills']);
    Route::get('/WeighBillController/weighBillReport/{id}', [WeighBillController::class, 'weighBillReport']);
    /** End Of Weigh Bill Controller */


    /** Goods Transfer Controller */
    Route::get('/GoodsTransferController/allEmployees', [GoodsTransferController::class, 'allEmployees']);
    Route::get('/GoodsTransferController/allSuppliers', [GoodsTransferController::class, 'allSuppliers']);
    Route::get('/GoodsTransferController/allProduct', [GoodsTransferController::class, 'allProduct']);
    Route::get('/GoodsTransferController/allStores', [GoodsTransferController::class, 'allStores']);
    Route::get('/GoodsTransferController/isApproved/{id}', [GoodsTransferController::class, 'isApproved']);
    Route::get('/GoodsTransferController/getGoodsTransfer/{id}', [GoodsTransferController::class, 'getGoodsTransfer']);
    Route::get('/GoodsTransferController/getUom/{id}', [GoodsTransferController::class, 'getUom']);
    Route::post('/GoodsTransferController/save', [GoodsTransferController::class, 'save']);
    Route::put('/GoodsTransferController/update/{id}', [GoodsTransferController::class, 'update']);
    Route::post('/GoodsTransferController/uploadAttachment', [GoodsTransferController::class, 'uploadAttachment'])->name('/GoodsTransferController/uploadAttachment');
    Route::get('/GoodsTransferController/allAttachment/{id}/{token}', [GoodsTransferController::class, 'allAttachment']);
    Route::get('/GoodsTransferController/getPoFromSupplier/{id}', [GoodsTransferController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferController/getPoFromSupplier/{id}', [GoodsTransferController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferController/getQty/{product_id}/{store_id}', [GoodsTransferController::class, 'getQty']);
    Route::get('/GoodsTransferController/getQtyUpdate/{product_id}/{store_id}', [GoodsTransferController::class, 'getQtyUpdate']);
    Route::delete('/GoodsTransferController/deleteGoodsTransfer/{id}', [GoodsTransferController::class, 'deleteGoodsTransfer']);
    Route::put('/GoodsTransferController/change_status/{id}', [GoodsTransferController::class, 'change_status']);
    Route::get('/GoodsTransferController/isApproved/{id}', [GoodsTransferController::class, 'isApproved']);
    Route::get('/GoodsTransferController/isValiedToUpdate/{id}', [GoodsTransferController::class, 'isValiedToUpdate']);
    Route::get('/GoodsTransferController/isMaterialIssue/{id}', [GoodsTransferController::class, 'isMaterialIssue']);
    /**End of Goods Transfer Controller Controller */

    /** Goods Transfer List Controller */
    Route::get('/GoodsTransferListController/allGoodsTransfer', [GoodsTransferListController::class, 'allGoodsTransfer']);
    Route::delete('/GoodsTransferListController/delete/{id}', [GoodsTransferListController::class, 'delete']);
    // 2025-02-17
    /** Goods transfer report */
    Route::get('/GoodsTransferListController/goodsTransferReport/{id}', [GoodsTransferListController::class, 'goodsTransferReport']);
    /** End of Goods transfer report */
    /**End of Goods Transfer List Controller */


    /** Goods Transfer bag Controller */
    Route::get('/GoodsTransferBagsController/allEmployees', [GoodsTransferBagsController::class, 'allEmployees']);
    Route::get('/GoodsTransferBagsController/allSuppliers', [GoodsTransferBagsController::class, 'allSuppliers']);
    Route::get('/GoodsTransferBagsController/allProduct', [GoodsTransferBagsController::class, 'allProduct']);
    Route::get('/GoodsTransferBagsController/allStores', [GoodsTransferBagsController::class, 'allStores']);
    Route::get('/GoodsTransferBagsController/allProductCustomer', [GoodsTransferBagsController::class, 'allProductCustomer']);
    
    Route::get('/GoodsTransferBagsController/isApproved/{id}', [GoodsTransferBagsController::class, 'isApproved']);
    Route::get('/GoodsTransferBagsController/getGoodsTransfer/{id}', [GoodsTransferBagsController::class, 'getGoodsTransfer']);
    Route::get('/GoodsTransferBagsController/getUom/{id}', [GoodsTransferBagsController::class, 'getUom']);
    Route::post('/GoodsTransferBagsController/save', [GoodsTransferBagsController::class, 'save']);
    Route::put('/GoodsTransferBagsController/update/{id}', [GoodsTransferBagsController::class, 'update']);
    Route::post('/GoodsTransferBagsController/uploadAttachment', [GoodsTransferBagsController::class, 'uploadAttachment'])->name('/GoodsTransferBagsController/uploadAttachment');
    Route::get('/GoodsTransferBagsController/allAttachment/{id}/{token}', [GoodsTransferBagsController::class, 'allAttachment']);
    Route::get('/GoodsTransferBagsController/getPoFromSupplier/{id}', [GoodsTransferBagsController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferBagsController/getPoFromSupplier/{id}', [GoodsTransferBagsController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferBagsController/getQty/{product_id}/{store_id}', [GoodsTransferBagsController::class, 'getQty']);
    Route::get('/GoodsTransferBagsController/getQtyUpdate/{product_id}/{store_id}', [GoodsTransferBagsController::class, 'getQtyUpdate']);
    Route::delete('/GoodsTransferBagsController/deleteGoodsTransfer/{id}', [GoodsTransferBagsController::class, 'deleteGoodsTransfer']);
    Route::put('/GoodsTransferBagsController/change_status/{id}', [GoodsTransferBagsController::class, 'change_status']);
    Route::get('/GoodsTransferBagsController/isApproved/{id}', [GoodsTransferBagsController::class, 'isApproved']);
    Route::get('/GoodsTransferBagsController/isValiedToUpdate/{id}', [GoodsTransferBagsController::class, 'isValiedToUpdate']);
    Route::get('/GoodsTransferBagsController/isMaterialIssue/{id}', [GoodsTransferBagsController::class, 'isMaterialIssue']);
    /**End of Goods Transfer bag Controller Controller */

    /** Goods Transfer Bag List Controller */
    Route::get('/GoodsTransferBagsListController/allGoodsTransfer', [GoodsTransferBagsListController::class, 'allGoodsTransfer']);
    Route::delete('/GoodsTransferBagsListController/delete/{id}', [GoodsTransferBagsListController::class, 'delete']);
    Route::get('/GoodsTransferBagsListController/goodsTransferReport/{id}', [GoodsTransferBagsListController::class, 'goodsTransferReport']);

    /**End of Goods Transfer Bag List Controller */


    /** Goods Transfer MR Controller */
    Route::get('/GoodsTransferMRController/allEmployees', [GoodsTransferMRController::class, 'allEmployees']);
    Route::get('/GoodsTransferMRController/allSuppliers', [GoodsTransferMRController::class, 'allSuppliers']);
    Route::get('/GoodsTransferMRController/allProduct', [GoodsTransferMRController::class, 'allProduct']);
    Route::get('/GoodsTransferMRController/allStores', [GoodsTransferMRController::class, 'allStores']);
    Route::get('/GoodsTransferMRController/allPurchaseOrders', [GoodsTransferMRController::class, 'allPurchaseOrders']);
    Route::get('/GoodsTransferMRController/getScheduledFactoryPO', [GoodsTransferMRController::class, 'getScheduledFactoryPO']);

    Route::get('/GoodsTransferMRController/isApproved/{id}', [GoodsTransferMRController::class, 'isApproved']);
    Route::get('/GoodsTransferMRController/getGoodsTransfer/{id}', [GoodsTransferMRController::class, 'getGoodsTransfer']);
    Route::get('/GoodsTransferMRController/getUom/{id}', [GoodsTransferMRController::class, 'getUom']);
    Route::post('/GoodsTransferMRController/save', [GoodsTransferMRController::class, 'save']);
    Route::put('/GoodsTransferMRController/update/{id}', [GoodsTransferMRController::class, 'update']);
    Route::post('/GoodsTransferMRController/uploadAttachment', [GoodsTransferMRController::class, 'uploadAttachment'])->name('/GoodsTransferMRController/uploadAttachment');
    Route::get('/GoodsTransferMRController/allAttachment/{id}/{token}', [GoodsTransferMRController::class, 'allAttachment']);
    Route::get('/GoodsTransferMRController/getPoFromSupplier/{id}', [GoodsTransferMRController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferMRController/getPoFromSupplier/{id}', [GoodsTransferMRController::class, 'getPoFromSupplier']);
    Route::get('/GoodsTransferMRController/getQty/{product_id}/{store_id}', [GoodsTransferMRController::class, 'getQty']);
    Route::get('/GoodsTransferMRController/getQtyUpdate/{product_id}/{store_id}', [GoodsTransferMRController::class, 'getQtyUpdate']);
    Route::delete('/GoodsTransferMRController/deleteGoodsTransfer/{id}', [GoodsTransferMRController::class, 'deleteGoodsTransfer']);
    Route::put('/GoodsTransferMRController/change_status/{id}', [GoodsTransferMRController::class, 'change_status']);
    Route::get('/GoodsTransferMRController/isApproved/{id}', [GoodsTransferMRController::class, 'isApproved']);
    Route::get('/GoodsTransferMRController/isValiedToUpdate/{id}', [GoodsTransferMRController::class, 'isValiedToUpdate']);
    /**End of Goods Transfer MR Controller Controller */






    /** Goods Transfer MR List Controller */
    Route::get('/GoodsTransferMRListController/allGoodsTransfer', [GoodsTransferMRListController::class, 'allGoodsTransfer']);
    Route::get('/GoodsTransferMRListController/goodsTransferMRReport/{id}', [GoodsTransferMRListController::class, 'goodsTransferMRReport']);
    Route::delete('/GoodsTransferMRListController/delete/{id}', [GoodsTransferMRListController::class, 'delete']);
    /**End of Goods Transfer MR List Controller */

    /** Goods Transfer MR Retrieve Controller */
    Route::get('/GoodsTransferMrRetrieveController/allMaterialRequisition', [GoodsTransferMrRetrieveController::class, 'allMaterialRequisition']);
    Route::get('/GoodsTransferMrRetrieveController/allMaterialRequisitionData/{id}', [GoodsTransferMrRetrieveController::class, 'allMaterialRequisitionData']);
    Route::get('/GoodsTransferMrRetrieveController/getSelectedMR/{id}', [GoodsTransferMrRetrieveController::class, 'getSelectedMR']);

    // Route::get('/GoodsTransferMrRetrieveController/getSelectedMR/{id}/{data_id}', [GoodsTransferMrRetrieveController::class, 'getSelectedMR']);
    Route::get('/GoodsTransferMrRetrieveController/getSelectedMRHeader/{id}', [GoodsTransferMrRetrieveController::class, 'getSelectedMRHeader']);
    /** End of Goods Transfer MR Retrieve Controller */


    /**bags Cutting Dispatch Controller */
    Route::get('/bagsCuttingDispatchController/allCuttingCenters', [BagsCuttingDispatchController::class, 'allCuttingCenters']);
    Route::get('/bagsCuttingDispatchController/allEmployees', [BagsCuttingDispatchController::class, 'allEmployees']);
    Route::get('/bagsCuttingDispatchController/allProjects', [BagsCuttingDispatchController::class, 'allProjects']);
    Route::get('/bagsCuttingDispatchController/allSuppliers', [BagsCuttingDispatchController::class, 'allSuppliers']);
    Route::get('/bagsCuttingDispatchController/allProduct', [BagsCuttingDispatchController::class, 'allProduct']);
    Route::get('/bagsCuttingDispatchController/allPurchaseOrder', [BagsCuttingDispatchController::class, 'allPurchaseOrder']);
    Route::get('/bagsCuttingDispatchController/getUom/{id}', [BagsCuttingDispatchController::class, 'getUom']);
    Route::get('/bagsCuttingDispatchController/allStores', [BagsCuttingDispatchController::class, 'allStores']);
    Route::get('/bagsCuttingDispatchController/getGrn/{id}', [BagsCuttingDispatchController::class, 'getGrn']);
    Route::get('/bagsCuttingDispatchController/getBagsCuttingDispatch/{id}', [BagsCuttingDispatchController::class, 'getBagsCuttingDispatch']);
    Route::get('/bagsCuttingDispatchController/getQty/{product_id}/{store_id}', [BagsCuttingDispatchController::class, 'getQty']);
    Route::get('/bagsCuttingDispatchController/allGrn', [BagsCuttingDispatchController::class, 'allGrn']);
    Route::get('/bagsCuttingDispatchController/allProductUnit', [BagsCuttingDispatchController::class, 'allProductUnit']);
    Route::post('/bagsCuttingDispatchController/save', [BagsCuttingDispatchController::class, 'save']);
    Route::put('/bagsCuttingDispatchController/update/{id}', [BagsCuttingDispatchController::class, 'update']);
    Route::get('/bagsCuttingDispatchController/allProductCustomer', [BagsCuttingDispatchController::class, 'allProductCustomer']);
    Route::put('/bagsCuttingDispatchController/change_status/{id}', [BagsCuttingDispatchController::class, 'change_status']);
    /**End of bags Cutting Dispatch Controller */

    /** Bags Grn List Controller */
    Route::get('/bagsCuttingDispatchListController/allCuttingDispatch', [BagsCuttingDispatchListController::class, 'allCuttingDispatch']);
    Route::get('/bagsCuttingDispatchListController/bagsCuttingDispatchReport/{id}', [BagsCuttingDispatchListController::class, 'bagsCuttingDispatchReport']);
    /**End of Bags Grn List Controller */

    /**bags Cutting Dispatch Controller */
    Route::get('/bagsCuttingReturnController/allCuttingCenters', [BagsCuttingReturnController::class, 'allCuttingCenters']);
    Route::get('/bagsCuttingReturnController/allEmployees', [BagsCuttingReturnController::class, 'allEmployees']);
    Route::get('/bagsCuttingReturnController/allProjects', [BagsCuttingReturnController::class, 'allProjects']);
    Route::get('/bagsCuttingReturnController/allSuppliers', [BagsCuttingReturnController::class, 'allSuppliers']);
    Route::get('/bagsCuttingReturnController/allProduct', [BagsCuttingReturnController::class, 'allProduct']);
    Route::get('/bagsCuttingReturnController/allPurchaseOrder', [BagsCuttingReturnController::class, 'allPurchaseOrder']);
    Route::get('/bagsCuttingReturnController/getUom/{id}', [BagsCuttingReturnController::class, 'getUom']);
    Route::get('/bagsCuttingReturnController/allStores', [BagsCuttingReturnController::class, 'allStores']);
    Route::get('/bagsCuttingReturnController/getGrn/{id}', [BagsCuttingReturnController::class, 'getGrn']);
    Route::get('/bagsCuttingReturnController/getBagsCuttingReturn/{id}', [BagsCuttingReturnController::class, 'getBagsCuttingReturn']);
    Route::get('/bagsCuttingReturnController/getQty/{product_id}/{store_id}', [BagsCuttingReturnController::class, 'getQty']);
    Route::get('/bagsCuttingReturnController/allGrn', [BagsCuttingReturnController::class, 'allGrn']);
    Route::get('/bagsCuttingReturnController/allProductUnit', [BagsCuttingReturnController::class, 'allProductUnit']);
    Route::post('/bagsCuttingReturnController/save', [BagsCuttingReturnController::class, 'save']);
    Route::put('/bagsCuttingReturnController/update/{id}', [BagsCuttingReturnController::class, 'update']);
    Route::get('/bagsCuttingReturnController/allProductCustomer', [BagsCuttingReturnController::class, 'allProductCustomer']);
    Route::put('/bagsCuttingReturnController/change_status/{id}', [BagsCuttingReturnController::class, 'change_status']);

    Route::get('/bagsCuttingReturnController/allBagsCuttingDispatch', [BagsCuttingReturnController::class, 'allBagsCuttingDispatch']);
    Route::get('/bagsCuttingReturnController/allBagsCuttingDispatchData/{id}', [BagsCuttingReturnController::class, 'allBagsCuttingDispatchData']);
    Route::get('/bagsCuttingReturnController/getSelectedBagsCuttingDispatchHeader/{id}', [BagsCuttingReturnController::class, 'getSelectedBagsCuttingDispatchHeader']);
    Route::get('/bagsCuttingReturnController/getSelectedBagsCuttingDispatchData/{id}', [BagsCuttingReturnController::class, 'getSelectedBagsCuttingDispatchData']);


    Route::get('/retrieveBagsMRController/getSelectedMR/{id}', [RetrieveBagsMRController::class, 'getSelectedMR']);
   
    

    /**End of bags Cutting Return Controller */


    /** Bags Grn List Controller */
    Route::get('/bagsCuttingReturnListController/allCuttingReturn', [BagsCuttingReturnListController::class, 'allCuttingReturn']);
    Route::get('/bagsCuttingReturnListController/bagsCuttingReturnReport/{id}', [BagsCuttingReturnListController::class, 'bagsCuttingReturnReport']);
    /**End of Bags Grn List Controller */




    /** Retrieve MR Controller */
    Route::get('/RetrieveMRController/allMaterialRequisition', [RetrieveMRController::class, 'allMaterialRequisition']);
    Route::get('/RetrieveMRController/allMaterialRequisitionData/{id}', [RetrieveMRController::class, 'allMaterialRequisitionData']);
    Route::get('/RetrieveMRController/getSelectedMR/{id}', [RetrieveMRController::class, 'getSelectedMR']);
    Route::get('/RetrieveMRController/getSelectedMRHeader/{id}', [RetrieveMRController::class, 'getSelectedMRHeader']);
    Route::put('/RetrieveMRController/change_status/{id}', [RetrieveMRController::class, 'change_status']);
    /** End of Retrieve MR Controller */

    /** Retrieve MR Bags Controller */
    Route::get('/RetrieveMRBagsController/allMaterialRequisition', [RetrieveMRBagsController::class, 'allMaterialRequisition']);
    Route::get('/RetrieveMRBagsController/allMaterialRequisitionData/{id}', [RetrieveMRBagsController::class, 'allMaterialRequisitionData']);
    Route::get('/RetrieveMRBagsController/getSelectedMR/{id}', [RetrieveMRBagsController::class, 'getSelectedMR']);
    Route::get('/RetrieveMRBagsController/getSelectedMRHeader/{id}', [RetrieveMRBagsController::class, 'getSelectedMRHeader']);
    Route::put('/RetrieveMRBagsController/change_status/{id}', [RetrieveMRBagsController::class, 'change_status']);
    /** End of Retrieve MR Bags Controller */



    /** Available Quantity Before Save Controller */
    Route::get('/AvailableQuantityBeforeSaveController/getAvailableQuantitySaveBefore/{product_id}/{store_id}', [AvailableQuantityBeforeSaveController::class, 'getAvailableQuantitySaveBefore']);
    Route::get('/AvailableQuantityBeforeSaveController/getAvailableQuantityUpdateBefore/{product_id}/{store_id}', [AvailableQuantityBeforeSaveController::class, 'getAvailableQuantityUpdateBefore']);
    /** End of Available Quantity Before Save Controller */



    /** Stock Valuation Report */
    Route::get('/StockValuationReportController/allSettings', [StockValuationReportController::class, 'allSettings']);
    Route::get('/stockReport/supplier_type', [StockValuationReportController::class, 'supplier_type']);
    Route::get('/StockValuationReportController/stockValuationAverageReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationAverageReport']);
    Route::get('/StockValuationReportController/stockValuationAverageAsAtReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationAverageAsAtReport']);
    Route::get('/StockValuationReportController/showStockValuationBatchWiseReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'showStockValuationBatchWiseReport']);
    Route::get('/StockValuationReportController/grnReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'grnReport']);
    Route::get('/StockValuationReportController/ginReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'ginReport']);
    Route::get('/StockValuationReportController/goodTransferReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'goodTransferReport']);
    Route::get('/StockValuationReportController/supplierListReport/{settings}', [StockValuationReportController::class, 'supplierListReport']);
    
    Route::get('/StockValuationReportController/grnMrReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'grnMrReport']);
    Route::get('/StockValuationReportController/mIssueMrReport/{settings}/{fromDate}/{toDate}', [StockValuationReportController::class, 'mIssueMrReport']);
    /** End of Stock Valuation Report */


    /** Stock Valuation Bags Report */
    Route::get('/StockValuationBagsReportController/allSettings', [StockValuationBagsReportController::class, 'allSettings']);
    Route::get('/StockValuationBagsReportController/category_level2/{id}', [StockValuationBagsReportController::class, 'category_level2']);
    Route::get('/StockValuationBagsReportController/category_level3/{id}', [StockValuationBagsReportController::class, 'category_level3']);
    Route::get('/StockValuationBagsReportController/supplier_type', [StockValuationBagsReportController::class, 'supplier_type']);
    Route::get('/StockValuationBagsReportController/stockValuationAverageReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'showStockValuationAverageReport']);
    Route::get('/StockValuationBagsReportController/stockValuationAverageAsAtReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'showStockValuationAverageAsAtReport']);
    Route::get('/StockValuationBagsReportController/showStockValuationBatchWiseReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'showStockValuationBatchWiseReport']);
    Route::get('/StockValuationBagsReportController/grnReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'grnReport']);
    Route::get('/StockValuationBagsReportController/ginReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'ginReport']);
    Route::get('/StockValuationBagsReportController/goodTransferReport/{settings}/{fromDate}/{toDate}', [StockValuationBagsReportController::class, 'goodTransferReport']);
    Route::get('/StockValuationBagsReportController/supplierListReport/{settings}', [StockValuationBagsReportController::class, 'supplierListReport']);
    /** End of Stock Valuation Bags Report */


    


    //get product reorder notification
    Route::get('/NotificationController/getProductReorderNotification', [NotificationController::class, 'getProductReorderNotification']);

    
});
